/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.antlr.v4.runtime.dfa;

import com.google.repacked.antlr.v4.runtime.dfa.AbstractEdgeMap;
import com.google.repacked.antlr.v4.runtime.dfa.ArrayEdgeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SparseEdgeMap<T>
extends AbstractEdgeMap<T> {
    private final int[] keys;
    private final List<T> values;

    /*
     * WARNING - void declaration
     */
    public SparseEdgeMap(int minIndex, int maxIndex) {
        this((int)var1_1, (int)var2_2, 5);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SparseEdgeMap(int minIndex, int maxIndex, int maxSparseSize) {
        super((int)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
        this.keys = new int[5];
        this.values = new ArrayList<T>(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private SparseEdgeMap(SparseEdgeMap<T> map, int maxSparseSize) {
        super(map.minIndex, map.maxIndex);
        SparseEdgeMap<T> sparseEdgeMap = map;
        synchronized (sparseEdgeMap) {
            void var1_1;
            void var2_3;
            if (maxSparseSize < map.values.size()) {
                throw new IllegalArgumentException();
            }
            this.keys = Arrays.copyOf(map.keys, maxSparseSize);
            this.values = new ArrayList<T>((int)var2_3);
            this.values.addAll(var1_1.values);
            return;
        }
    }

    public final int[] getKeys() {
        return this.keys;
    }

    public final List<T> getValues() {
        return this.values;
    }

    private int size() {
        return this.values.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.values.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T get(int key) {
        void var1_1;
        int index = Arrays.binarySearch(this.keys, 0, this.size(), key);
        if (index < 0) {
            return null;
        }
        return this.values.get((int)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final AbstractEdgeMap<T> put(int key, T value) {
        if (key < this.minIndex || key > this.maxIndex) {
            return this;
        }
        if (value == null) {
            return this.remove(key);
        }
        SparseEdgeMap sparseEdgeMap = this;
        synchronized (sparseEdgeMap) {
            void var2_3;
            void var1_1;
            void arrayMap2;
            int n;
            int index = Arrays.binarySearch(this.keys, 0, this.size(), key);
            if (index >= 0) {
                this.values.set(index, value);
                return this;
            }
            assert (index < 0 && value != null);
            int insertIndex = -index - 1;
            SparseEdgeMap sparseEdgeMap2 = this;
            if (this.size() < sparseEdgeMap2.keys.length && insertIndex == this.size()) {
                this.keys[insertIndex] = key;
                this.values.add(value);
                return this;
            }
            sparseEdgeMap2 = this;
            if (this.size() >= sparseEdgeMap2.keys.length) {
                sparseEdgeMap2 = this;
                n = sparseEdgeMap2.keys.length << 1;
            } else {
                sparseEdgeMap2 = this;
                n = sparseEdgeMap2.keys.length;
            }
            int desiredSize2 = n;
            int space = this.maxIndex - this.minIndex + 1;
            if (desiredSize2 >= space / 2) {
                ArrayEdgeMap desiredSize2 = new ArrayEdgeMap(this.minIndex, this.maxIndex);
                ArrayEdgeMap arrayMap2 = desiredSize2.putAll(this);
                arrayMap2.put(key, (Object)value);
                return arrayMap2;
            }
            SparseEdgeMap<T> resized = new SparseEdgeMap<T>(this, (int)arrayMap2);
            System.arraycopy(resized.keys, insertIndex, resized.keys, insertIndex + 1, this.size() - insertIndex);
            resized.keys[insertIndex] = var1_1;
            resized.values.add(insertIndex, var2_3);
            return resized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private SparseEdgeMap<T> remove(int key) {
        SparseEdgeMap sparseEdgeMap = this;
        synchronized (sparseEdgeMap) {
            void var1_1;
            int index = Arrays.binarySearch(this.keys, 0, this.size(), key);
            if (index < 0) {
                return this;
            }
            SparseEdgeMap sparseEdgeMap2 = this;
            SparseEdgeMap<T> result = new SparseEdgeMap<T>(this, sparseEdgeMap2.keys.length);
            System.arraycopy(result.keys, index + 1, result.keys, index, this.size() - index - 1);
            result.values.remove((int)var1_1);
            return sparseEdgeMap2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final Map<Integer, T> toMap() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        SparseEdgeMap sparseEdgeMap = this;
        synchronized (sparseEdgeMap) {
            void var2_2;
            LinkedHashMap<Integer, T> result = new LinkedHashMap<Integer, T>();
            for (int i = 0; i < this.size(); ++i) {
                result.put(this.keys[i], this.values.get(i));
            }
            return var2_2;
        }
    }
}

