/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.antlr.v4.runtime.tree.gui;

import com.google.repacked.antlr.v4.runtime.tree.gui.SystemFontMetrics;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class PostScriptDocument {
    private static Map<String, String> POSTSCRIPT_FONT_NAMES = new HashMap<String, String>();
    private int boundingBoxWidth;
    private int boundingBoxHeight;
    private SystemFontMetrics fontMetrics;
    private String fontName;
    private int fontSize = 12;
    private String boundingBox;
    private StringBuilder ps = new StringBuilder();
    private boolean closed = false;

    public PostScriptDocument() {
        this("Courier New", 12);
    }

    /*
     * WARNING - void declaration
     */
    public PostScriptDocument(String fontName, int fontSize) {
        PostScriptDocument postScriptDocument;
        void var2_2;
        this.header();
        void var3_4 = var2_2;
        String string = postScriptDocument;
        postScriptDocument = this;
        this.fontMetrics = new SystemFontMetrics(string);
        postScriptDocument.fontName = postScriptDocument.fontMetrics.getFont().getPSName();
        postScriptDocument.fontSize = var3_4;
        string = POSTSCRIPT_FONT_NAMES.get(postScriptDocument.fontName);
        if (string == null) {
            string = postScriptDocument.fontName;
        }
        postScriptDocument.ps.append(String.format(Locale.US, "/%s findfont %d scalefont setfont\n", string, (int)var3_4));
    }

    public final String getPS() {
        this.close();
        return this.header() + this.ps.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void boundingBox(int w, int h) {
        void var2_2;
        void var1_1;
        this.boundingBoxWidth = var1_1;
        this.boundingBoxHeight = var2_2;
        this.boundingBox = String.format(Locale.US, "%%%%BoundingBox: %d %d %d %d\n", 0, 0, this.boundingBoxWidth, this.boundingBoxHeight);
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        this.ps.append("%%Trailer\n");
        this.closed = true;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder header() {
        void var1_1;
        StringBuilder b = new StringBuilder();
        b.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        b.append(this.boundingBox).append("\n");
        b.append("0.3 setlinewidth\n");
        b.append("%% x y w h highlight\n/highlight {\n        4 dict begin\n        /h exch def\n        /w exch def\n        /y exch def\n        /x exch def\n        gsave\n        newpath\n        x y moveto\n        0 h rlineto     % up to left corner\n        w 0 rlineto     % to upper right corner\n        0 h neg rlineto % to lower right corner\n        w neg 0 rlineto % back home to lower left corner\n        closepath\n        .95 .83 .82 setrgbcolor\n        fill\n        grestore\n        end\n} def\n");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void move(double x, double y) {
        void var3_2;
        void var1_1;
        this.ps.append(String.format(Locale.US, "%1.3f %1.3f moveto\n", (double)var1_1, (double)var3_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void line(double x1, double y1, double x2, double y2) {
        void var3_3;
        void var1_1;
        this.move((double)var1_1, (double)var3_3);
        double d = y2;
        double d2 = x2;
        PostScriptDocument postScriptDocument = this;
        postScriptDocument.ps.append(String.format(Locale.US, "%1.3f %1.3f lineto\n", d2, d));
    }

    /*
     * WARNING - void declaration
     */
    public final void highlight(double x, double y, double width, double height) {
        void var3_2;
        void var1_1;
        this.ps.append(String.format(Locale.US, "%1.3f %1.3f %1.3f %1.3f highlight\n", (double)var1_1, (double)var3_2, width, height));
    }

    /*
     * WARNING - void declaration
     */
    public final void text(String s, double x, double y) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '(': 
                case ')': 
                case '\\': {
                    buf.append('\\');
                    buf.append(c);
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        Object object = buf.toString();
        this.move((double)var2_2, y);
        this.ps.append(String.format(Locale.US, "(%s) show\n", object));
        object = this;
        ((PostScriptDocument)object).ps.append("stroke\n");
    }

    /*
     * WARNING - void declaration
     */
    public final double getWidth(String s) {
        void var1_1;
        return this.fontMetrics.getWidth((String)var1_1, this.fontSize);
    }

    public final double getLineHeight() {
        return this.fontMetrics.getLineHeight(this.fontSize);
    }

    static {
        POSTSCRIPT_FONT_NAMES.put("SansSerif.plain", "ArialMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.bold", "Arial-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.italic", "Arial-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.bolditalic", "Arial-BoldItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.plain", "TimesNewRomanPSMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.bold", "TimesNewRomanPS-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.italic", "TimesNewRomanPS-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.bolditalic", "TimesNewRomanPS-BoldItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.plain", "CourierNewPSMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.bold", "CourierNewPS-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.italic", "CourierNewPS-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.bolditalic", "CourierNewPS-BoldItalicMT");
    }
}

