/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.apache.commons.lang3;

import com.google.repacked.apache.commons.lang3.StringUtils;
import com.google.repacked.apache.commons.lang3.text.translate.AggregateTranslator;
import com.google.repacked.apache.commons.lang3.text.translate.CharSequenceTranslator;
import com.google.repacked.apache.commons.lang3.text.translate.EntityArrays;
import com.google.repacked.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import com.google.repacked.apache.commons.lang3.text.translate.LookupTranslator;
import com.google.repacked.apache.commons.lang3.text.translate.NumericEntityEscaper;
import com.google.repacked.apache.commons.lang3.text.translate.NumericEntityUnescaper;
import com.google.repacked.apache.commons.lang3.text.translate.OctalUnescaper;
import com.google.repacked.apache.commons.lang3.text.translate.UnicodeUnescaper;
import com.google.repacked.apache.commons.lang3.text.translate.UnicodeUnpairedSurrogateRemover;
import java.io.IOException;
import java.io.Writer;

public final class StringEscapeUtils {
    private static CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator({"\"", "\\\""}, {"\\", "\\\\"}).with(new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE())).with(JavaUnicodeEscaper.outsideOf(32, 127));
    private static CharSequenceTranslator ESCAPE_XML10;
    private static CharSequenceTranslator UNESCAPE_JAVA;
    private static CharSequenceTranslator UNESCAPE_XML;

    public static final String escapeJava(String input) {
        String string;
        return ESCAPE_JAVA.translate(string);
    }

    public static String escapeXml10(String input) {
        String string;
        return ESCAPE_XML10.translate(string);
    }

    public static final String unescapeXml(String input) {
        String string;
        return UNESCAPE_XML.translate(string);
    }

    static {
        new AggregateTranslator(new LookupTranslator({"'", "\\'"}, {"\"", "\\\""}, {"\\", "\\\\"}, {"/", "\\/"}), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), JavaUnicodeEscaper.outsideOf(32, 127));
        new AggregateTranslator(new LookupTranslator({"\"", "\\\""}, {"\\", "\\\\"}, {"/", "\\/"}), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), JavaUnicodeEscaper.outsideOf(32, 127));
        new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE()));
        ESCAPE_XML10 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE()), new LookupTranslator({"\u0000", ""}, {"\u0001", ""}, {"\u0002", ""}, {"\u0003", ""}, {"\u0004", ""}, {"\u0005", ""}, {"\u0006", ""}, {"\u0007", ""}, {"\b", ""}, {"\u000b", ""}, {"\f", ""}, {"\u000e", ""}, {"\u000f", ""}, {"\u0010", ""}, {"\u0011", ""}, {"\u0012", ""}, {"\u0013", ""}, {"\u0014", ""}, {"\u0015", ""}, {"\u0016", ""}, {"\u0017", ""}, {"\u0018", ""}, {"\u0019", ""}, {"\u001a", ""}, {"\u001b", ""}, {"\u001c", ""}, {"\u001d", ""}, {"\u001e", ""}, {"\u001f", ""}, {"\ufffe", ""}, {"\uffff", ""}), NumericEntityEscaper.between(127, 132), NumericEntityEscaper.between(134, 159), new UnicodeUnpairedSurrogateRemover());
        new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE()), new LookupTranslator({"\u0000", ""}, {"\u000b", "&#11;"}, {"\f", "&#12;"}, {"\ufffe", ""}, {"\uffff", ""}), NumericEntityEscaper.between(1, 8), NumericEntityEscaper.between(14, 31), NumericEntityEscaper.between(127, 132), NumericEntityEscaper.between(134, 159), new UnicodeUnpairedSurrogateRemover());
        new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE()));
        new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator(EntityArrays.HTML40_EXTENDED_ESCAPE()));
        new CsvEscaper();
        UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE()), new LookupTranslator({"\\\\", "\\"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\", ""}));
        new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE()), new LookupTranslator(EntityArrays.HTML40_EXTENDED_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_XML = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.APOS_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        new CsvUnescaper();
    }

    static final class CsvUnescaper
    extends CharSequenceTranslator {
        private static final String CSV_QUOTE_STR = "\"";
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        CsvUnescaper() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int translate(CharSequence input, int index, Writer out) throws IOException {
            void var1_1;
            if (index != 0) {
                throw new IllegalStateException("CsvUnescaper should never reach the [1] index");
            }
            if (input.charAt(0) != '\"' || input.charAt(input.length() - 1) != '\"') {
                out.write(input.toString());
                return Character.codePointCount(input, 0, input.length());
            }
            String quoteless = input.subSequence(1, input.length() - 1).toString();
            if (StringUtils.containsAny(quoteless, CSV_SEARCH_CHARS)) {
                void var2_3;
                out.write(StringUtils.replace((String)var2_3, CSV_QUOTE_STR + CSV_QUOTE_STR, CSV_QUOTE_STR));
            } else {
                void var3_4;
                var3_4.write(input.toString());
            }
            return Character.codePointCount(input, 0, var1_1.length());
        }
    }

    static final class CsvEscaper
    extends CharSequenceTranslator {
        private static final String CSV_QUOTE_STR = "\"";
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        CsvEscaper() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int translate(CharSequence input, int index, Writer out) throws IOException {
            void var1_1;
            if (index != 0) {
                throw new IllegalStateException("CsvEscaper should never reach the [1] index");
            }
            if (StringUtils.containsNone(input.toString(), CSV_SEARCH_CHARS)) {
                out.write(input.toString());
            } else {
                void var3_3;
                out.write(34);
                out.write(StringUtils.replace(input.toString(), CSV_QUOTE_STR, CSV_QUOTE_STR + CSV_QUOTE_STR));
                var3_3.write(34);
            }
            return Character.codePointCount(input, 0, var1_1.length());
        }
    }
}

