/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;

public abstract class CharsetProber {
    public abstract String getCharSetName();

    public abstract ProbingState handleData(byte[] var1, int var2, int var3);

    public abstract ProbingState getState();

    public abstract void reset();

    public abstract float getConfidence();

    /*
     * WARNING - void declaration
     */
    public final ByteBuffer filterWithoutEnglishLetters(byte[] buf, int offset, int length) {
        int curPtr;
        ByteBuffer out = ByteBuffer.allocate(length);
        boolean meetMSB = false;
        int prevPtr = offset;
        int maxPtr = offset + length;
        for (curPtr = offset; curPtr < maxPtr; ++curPtr) {
            void var2_2;
            byte c = buf[curPtr];
            if (!CharsetProber.isAscii(c)) {
                meetMSB = true;
                continue;
            }
            if (!CharsetProber.isAsciiSymbol((byte)var2_2)) continue;
            if (meetMSB && curPtr > prevPtr) {
                out.put(buf, prevPtr, curPtr - prevPtr);
                out.put((byte)32);
                prevPtr = curPtr + 1;
                meetMSB = false;
                continue;
            }
            prevPtr = curPtr + 1;
        }
        if (meetMSB && curPtr > prevPtr) {
            void var1_1;
            out.put((byte[])var1_1, prevPtr, curPtr - prevPtr);
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuffer filterWithEnglishLetters(byte[] buf, int offset, int length) {
        int curPtr;
        ByteBuffer out = ByteBuffer.allocate(length);
        boolean isInTag = false;
        int prevPtr = offset;
        int maxPtr = offset + length;
        for (curPtr = offset; curPtr < maxPtr; ++curPtr) {
            void var2_2;
            byte c = buf[curPtr];
            if (c == 62) {
                isInTag = false;
            } else if (c == 60) {
                isInTag = true;
            }
            if (!CharsetProber.isAscii(c) || !CharsetProber.isAsciiSymbol((byte)var2_2)) continue;
            if (curPtr > prevPtr && !isInTag) {
                out.put(buf, prevPtr, curPtr - prevPtr);
                out.put((byte)32);
            }
            prevPtr = curPtr + 1;
        }
        if (!isInTag && curPtr > prevPtr) {
            void var1_1;
            out.put((byte[])var1_1, prevPtr, curPtr - prevPtr);
        }
        return out;
    }

    private static boolean isAscii(byte b) {
        return (b & 0x80) == 0;
    }

    private static boolean isAsciiSymbol(byte b) {
        byte by;
        int n = b & 0xFF;
        byte c = (byte)n;
        return n < 65 || c > 90 && c < 97 || by > 122;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProbingState {
        DETECTING,
        FOUND_IT,
        NOT_ME;

    }
}

