/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public final class Latin1Prober
extends CharsetProber {
    private CharsetProber.ProbingState state;
    private byte lastCharClass;
    private int[] freqCounter = new int[4];
    private static final byte[] latin1CharToClass = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 0, 1, 7, 1, 1, 1, 1, 1, 1, 5, 1, 5, 0, 5, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 7, 0, 7, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 6, 1, 6, 6, 6, 6, 6, 7, 7, 7};
    private static final byte[] latin1ClassModel = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 1, 1, 3, 3, 0, 3, 3, 3, 1, 2, 1, 2, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 1, 3, 1, 1, 1, 3, 0, 3, 1, 3, 1, 1, 3, 3};

    public Latin1Prober() {
        this.reset();
    }

    public final String getCharSetName() {
        return Constants.CHARSET_WINDOWS_1252;
    }

    /*
     * WARNING - void declaration
     */
    public final float getConfidence() {
        float confidence;
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        int total = 0;
        for (int i = 0; i < this.freqCounter.length; ++i) {
            total += this.freqCounter[i];
        }
        if (total <= 0) {
            confidence = 0.0f;
        } else {
            void var1_1;
            confidence = (float)this.freqCounter[3] / (float)total;
            confidence -= (float)this.freqCounter[1] * 20.0f / (float)var1_1;
        }
        if (confidence < 0.0f) {
            confidence = 0.0f;
        }
        return (float)(var2_3 *= 0.5f);
    }

    public final CharsetProber.ProbingState getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public final CharsetProber.ProbingState handleData(byte[] buf, int offset, int length) {
        ByteBuffer newBufTmp = this.filterWithEnglishLetters(buf, offset, length);
        byte[] newBuf = newBufTmp.array();
        int newBufLen = newBufTmp.position();
        for (int i = 0; i < newBufLen; ++i) {
            void var1_2;
            void var2_3;
            int c = newBuf[i] & 0xFF;
            byte charClass = latin1CharToClass[c];
            byte freq = latin1ClassModel[(this.lastCharClass << 3) + charClass];
            if (freq == 0) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            void v0 = var2_3;
            this.freqCounter[v0] = this.freqCounter[v0] + 1;
            this.lastCharClass = var1_2;
        }
        return this.state;
    }

    public final void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        this.lastCharClass = 1;
        for (int i = 0; i < this.freqCounter.length; ++i) {
            this.freqCounter[i] = 0;
        }
    }
}

