/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.sequence.SequenceModel;

public final class SingleByteCharsetProber
extends CharsetProber {
    private CharsetProber.ProbingState state;
    private SequenceModel model;
    private boolean reversed;
    private short lastOrder;
    private int totalSeqs;
    private int[] seqCounters;
    private int totalChar;
    private int freqChar;
    private CharsetProber nameProber;

    /*
     * WARNING - void declaration
     */
    public SingleByteCharsetProber(SequenceModel model) {
        void var1_1;
        this.model = var1_1;
        this.reversed = false;
        this.nameProber = null;
        this.seqCounters = new int[4];
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    public SingleByteCharsetProber(SequenceModel model, boolean reversed, CharsetProber nameProber) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.model = var1_1;
        this.reversed = var2_2;
        this.nameProber = var3_3;
        this.seqCounters = new int[4];
        this.reset();
    }

    public final String getCharSetName() {
        if (this.nameProber == null) {
            return this.model.getCharsetName();
        }
        return this.nameProber.getCharSetName();
    }

    public final float getConfidence() {
        if (this.totalSeqs > 0) {
            float f;
            float f2 = 1.0f * (float)this.seqCounters[3] / (float)this.totalSeqs / this.model.getTypicalPositiveRatio();
            float r = f2 * (float)this.freqChar / (float)this.totalChar;
            if (f >= 1.0f) {
                r = 0.99f;
            }
            return f2;
        }
        return 0.01f;
    }

    public final CharsetProber.ProbingState getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public final CharsetProber.ProbingState handleData(byte[] buf, int offset, int length) {
        int maxPos = offset + length;
        for (int i = offset; i < maxPos; ++i) {
            void var2_2;
            short order = this.model.getOrder(buf[i]);
            if (order < 250) {
                ++this.totalChar;
            }
            if (order < 64) {
                ++this.freqChar;
                if (this.lastOrder < 64) {
                    ++this.totalSeqs;
                    if (!this.reversed) {
                        byte by = this.model.getPrecedence((this.lastOrder << 6) + order);
                        this.seqCounters[by] = this.seqCounters[by] + 1;
                    } else {
                        byte by = this.model.getPrecedence((order << 6) + this.lastOrder);
                        this.seqCounters[by] = this.seqCounters[by] + 1;
                    }
                }
            }
            this.lastOrder = var2_2;
        }
        if (this.state == CharsetProber.ProbingState.DETECTING && this.totalSeqs > 1024) {
            float f;
            float cf = this.getConfidence();
            if (f > 0.95f) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
            } else if (cf < 0.05f) {
                this.state = CharsetProber.ProbingState.NOT_ME;
            }
        }
        return this.state;
    }

    public final void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        this.lastOrder = (short)255;
        for (int i = 0; i < 4; ++i) {
            this.seqCounters[i] = 0;
        }
        this.totalSeqs = 0;
        this.totalChar = 0;
        this.freqChar = 0;
    }
}

