/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.design.R;
import android.support.design.internal.BottomNavigationItemView;
import android.support.design.internal.BottomNavigationPresenter;
import android.support.design.internal.TextScale;
import android.support.transition.AutoTransition;
import android.support.transition.Transition;
import android.support.transition.TransitionManager;
import android.support.transition.TransitionSet;
import android.support.v4.util.Pools;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuPresenter;
import android.support.v7.view.menu.MenuView;
import android.util.AttributeSet;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BottomNavigationMenuView
extends ViewGroup
implements MenuView {
    private static final long ACTIVE_ANIMATION_DURATION_MS = 115L;
    private final TransitionSet mSet;
    private final int mInactiveItemMaxWidth;
    private final int mInactiveItemMinWidth;
    private final int mActiveItemMaxWidth;
    private final int mItemHeight;
    private final View.OnClickListener mOnClickListener;
    private final Pools.Pool<BottomNavigationItemView> mItemPool = new Pools.SynchronizedPool(5);
    private boolean mShiftingMode = true;
    private BottomNavigationItemView[] mButtons;
    private int mSelectedItemId = 0;
    private int mSelectedItemPosition = 0;
    private ColorStateList mItemIconTint;
    private ColorStateList mItemTextColor;
    private int mItemBackgroundRes;
    private int[] mTempChildWidths;
    private BottomNavigationPresenter mPresenter;
    private MenuBuilder mMenu;

    public BottomNavigationMenuView(Context context) {
        this(context, null);
    }

    public BottomNavigationMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = this.getResources();
        this.mInactiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_max_width);
        this.mInactiveItemMinWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_min_width);
        this.mActiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_max_width);
        this.mItemHeight = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_height);
        this.mSet = new AutoTransition();
        this.mSet.setOrdering(0);
        this.mSet.setDuration(115L);
        this.mSet.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        this.mSet.addTransition((Transition)new TextScale());
        this.mOnClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                BottomNavigationItemView itemView = (BottomNavigationItemView)v;
                MenuItemImpl item = itemView.getItemData();
                if (!BottomNavigationMenuView.this.mMenu.performItemAction((MenuItem)item, (MenuPresenter)BottomNavigationMenuView.this.mPresenter, 0)) {
                    item.setChecked(true);
                }
            }
        };
        this.mTempChildWidths = new int[5];
    }

    public void initialize(MenuBuilder menu) {
        this.mMenu = menu;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int count = this.getChildCount();
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mItemHeight, (int)0x40000000);
        if (this.mShiftingMode) {
            int inactiveCount = count - 1;
            int activeMaxAvailable = width - inactiveCount * this.mInactiveItemMinWidth;
            int activeWidth = Math.min(activeMaxAvailable, this.mActiveItemMaxWidth);
            int inactiveMaxAvailable = (width - activeWidth) / inactiveCount;
            int inactiveWidth = Math.min(inactiveMaxAvailable, this.mInactiveItemMaxWidth);
            int extra = width - activeWidth - inactiveWidth * inactiveCount;
            for (int i = 0; i < count; ++i) {
                int n = this.mTempChildWidths[i] = i == this.mSelectedItemPosition ? activeWidth : inactiveWidth;
                if (extra <= 0) continue;
                int n2 = i;
                this.mTempChildWidths[n2] = this.mTempChildWidths[n2] + 1;
                --extra;
            }
        } else {
            int maxAvailable = width / (count == 0 ? 1 : count);
            int childWidth = Math.min(maxAvailable, this.mActiveItemMaxWidth);
            int extra = width - childWidth * count;
            for (int i = 0; i < count; ++i) {
                this.mTempChildWidths[i] = childWidth;
                if (extra <= 0) continue;
                int n = i;
                this.mTempChildWidths[n] = this.mTempChildWidths[n] + 1;
                --extra;
            }
        }
        int totalWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)this.mTempChildWidths[i], (int)0x40000000), heightSpec);
            ViewGroup.LayoutParams params = child.getLayoutParams();
            params.width = child.getMeasuredWidth();
            totalWidth += child.getMeasuredWidth();
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)totalWidth, (int)View.MeasureSpec.makeMeasureSpec((int)totalWidth, (int)0x40000000), (int)0), View.resolveSizeAndState((int)this.mItemHeight, (int)heightSpec, (int)0));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int width = right - left;
        int height = bottom - top;
        int used = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (ViewCompat.getLayoutDirection((View)this) == 1) {
                child.layout(width - used - child.getMeasuredWidth(), 0, width - used, height);
            } else {
                child.layout(used, 0, child.getMeasuredWidth() + used, height);
            }
            used += child.getMeasuredWidth();
        }
    }

    public int getWindowAnimations() {
        return 0;
    }

    public void setIconTintList(ColorStateList tint) {
        this.mItemIconTint = tint;
        if (this.mButtons == null) {
            return;
        }
        for (BottomNavigationItemView item : this.mButtons) {
            item.setIconTintList(tint);
        }
    }

    @Nullable
    public ColorStateList getIconTintList() {
        return this.mItemIconTint;
    }

    public void setItemTextColor(ColorStateList color2) {
        this.mItemTextColor = color2;
        if (this.mButtons == null) {
            return;
        }
        for (BottomNavigationItemView item : this.mButtons) {
            item.setTextColor(color2);
        }
    }

    public ColorStateList getItemTextColor() {
        return this.mItemTextColor;
    }

    public void setItemBackgroundRes(int background) {
        this.mItemBackgroundRes = background;
        if (this.mButtons == null) {
            return;
        }
        for (BottomNavigationItemView item : this.mButtons) {
            item.setItemBackground(background);
        }
    }

    public int getItemBackgroundRes() {
        return this.mItemBackgroundRes;
    }

    public void setPresenter(BottomNavigationPresenter presenter) {
        this.mPresenter = presenter;
    }

    public void buildMenuView() {
        this.removeAllViews();
        if (this.mButtons != null) {
            for (BottomNavigationItemView item : this.mButtons) {
                this.mItemPool.release((Object)item);
            }
        }
        if (this.mMenu.size() == 0) {
            this.mSelectedItemId = 0;
            this.mSelectedItemPosition = 0;
            this.mButtons = null;
            return;
        }
        this.mButtons = new BottomNavigationItemView[this.mMenu.size()];
        this.mShiftingMode = this.mMenu.size() > 3;
        for (int i = 0; i < this.mMenu.size(); ++i) {
            BottomNavigationItemView child;
            this.mPresenter.setUpdateSuspended(true);
            this.mMenu.getItem(i).setCheckable(true);
            this.mPresenter.setUpdateSuspended(false);
            this.mButtons[i] = child = this.getNewItem();
            child.setIconTintList(this.mItemIconTint);
            child.setTextColor(this.mItemTextColor);
            child.setItemBackground(this.mItemBackgroundRes);
            child.setShiftingMode(this.mShiftingMode);
            child.initialize((MenuItemImpl)this.mMenu.getItem(i), 0);
            child.setItemPosition(i);
            child.setOnClickListener(this.mOnClickListener);
            this.addView((View)child);
        }
        this.mSelectedItemPosition = Math.min(this.mMenu.size() - 1, this.mSelectedItemPosition);
        this.mMenu.getItem(this.mSelectedItemPosition).setChecked(true);
    }

    public void updateMenuView() {
        int i;
        int menuSize = this.mMenu.size();
        if (menuSize != this.mButtons.length) {
            this.buildMenuView();
            return;
        }
        int previousSelectedId = this.mSelectedItemId;
        for (i = 0; i < menuSize; ++i) {
            MenuItem item = this.mMenu.getItem(i);
            if (!item.isChecked()) continue;
            this.mSelectedItemId = item.getItemId();
            this.mSelectedItemPosition = i;
        }
        if (previousSelectedId != this.mSelectedItemId) {
            TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)this.mSet);
        }
        for (i = 0; i < menuSize; ++i) {
            this.mPresenter.setUpdateSuspended(true);
            this.mButtons[i].initialize((MenuItemImpl)this.mMenu.getItem(i), 0);
            this.mPresenter.setUpdateSuspended(false);
        }
    }

    private BottomNavigationItemView getNewItem() {
        BottomNavigationItemView item = (BottomNavigationItemView)((Object)this.mItemPool.acquire());
        if (item == null) {
            item = new BottomNavigationItemView(this.getContext());
        }
        return item;
    }

    public int getSelectedItemId() {
        return this.mSelectedItemId;
    }

    void tryRestoreSelectedItemId(int itemId) {
        int size = this.mMenu.size();
        for (int i = 0; i < size; ++i) {
            MenuItem item = this.mMenu.getItem(i);
            if (itemId != item.getItemId()) continue;
            this.mSelectedItemId = itemId;
            this.mSelectedItemPosition = i;
            item.setChecked(true);
            break;
        }
    }
}

