/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner;

import android.app.Instrumentation;
import android.os.Build;
import android.os.Bundle;
import android.support.test.internal.runner.RunnerArgs;
import android.support.test.internal.runner.TestExecutor;
import android.support.test.internal.runner.TestRequest;
import android.support.test.internal.runner.TestRequestBuilder;
import android.support.test.internal.runner.listener.ActivityFinisherRunListener;
import android.support.test.internal.runner.listener.CoverageListener;
import android.support.test.internal.runner.listener.DelayInjector;
import android.support.test.internal.runner.listener.InstrumentationResultPrinter;
import android.support.test.internal.runner.listener.LogRunListener;
import android.support.test.internal.runner.listener.SuiteAssignmentPrinter;
import android.support.test.internal.runner.tracker.AnalyticsBasedUsageTracker;
import android.support.test.internal.runner.tracker.UsageTracker;
import android.support.test.internal.runner.tracker.UsageTrackerRegistry;
import android.support.test.runner.MonitoringInstrumentation;
import android.support.test.runner.lifecycle.ApplicationLifecycleCallback;
import android.support.test.runner.lifecycle.ApplicationLifecycleMonitorRegistry;
import android.util.Log;
import org.junit.runner.notification.RunListener;

public class AndroidJUnitRunner
extends MonitoringInstrumentation {
    private static final String LOG_TAG = "AndroidJUnitRunner";
    private Bundle mArguments;
    private InstrumentationResultPrinter mInstrumentationResultPrinter = null;
    private RunnerArgs mRunnerArgs;

    @Override
    public void onCreate(Bundle arguments) {
        super.onCreate(arguments);
        this.mArguments = arguments;
        this.mRunnerArgs = new RunnerArgs.Builder().fromManifest((Instrumentation)this).fromBundle(this.getArguments()).build();
        for (ApplicationLifecycleCallback listener : this.mRunnerArgs.appListeners) {
            ApplicationLifecycleMonitorRegistry.getInstance().addLifecycleCallback(listener);
        }
        this.start();
    }

    private Bundle getArguments() {
        return this.mArguments;
    }

    InstrumentationResultPrinter getInstrumentationResultPrinter() {
        return this.mInstrumentationResultPrinter;
    }

    @Override
    public void onStart() {
        super.onStart();
        Bundle results = new Bundle();
        try {
            TestExecutor.Builder executorBuilder = new TestExecutor.Builder((Instrumentation)this);
            if (this.mRunnerArgs.debug) {
                executorBuilder.setWaitForDebugger(true);
            }
            this.addListeners(this.mRunnerArgs, executorBuilder);
            TestRequest testRequest = this.buildRequest(this.mRunnerArgs, this.getArguments());
            results = executorBuilder.build().execute(testRequest);
        }
        catch (RuntimeException e) {
            String msg = "Fatal exception when running tests";
            Log.e((String)LOG_TAG, (String)"Fatal exception when running tests", (Throwable)e);
            results.putString("stream", "Fatal exception when running tests\n" + Log.getStackTraceString((Throwable)e));
        }
        this.finish(-1, results);
    }

    @Override
    public void finish(int resultCode, Bundle results) {
        try {
            UsageTrackerRegistry.getInstance().trackUsage(LOG_TAG);
            UsageTrackerRegistry.getInstance().sendUsages();
        }
        catch (RuntimeException re) {
            Log.w((String)LOG_TAG, (String)"Failed to send analytics.", (Throwable)re);
        }
        super.finish(resultCode, results);
    }

    private void addListeners(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.suiteAssignment) {
            builder.addRunListener(new SuiteAssignmentPrinter());
        } else {
            builder.addRunListener(new LogRunListener());
            this.mInstrumentationResultPrinter = new InstrumentationResultPrinter();
            builder.addRunListener(this.mInstrumentationResultPrinter);
            builder.addRunListener(new ActivityFinisherRunListener((Instrumentation)this, new MonitoringInstrumentation.ActivityFinisher()));
            this.addDelayListener(args, builder);
            this.addCoverageListener(args, builder);
        }
        this.addListenersFromArg(args, builder);
    }

    private void addCoverageListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.codeCoverage) {
            builder.addRunListener(new CoverageListener(args.codeCoveragePath));
        }
    }

    private void addDelayListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.delayMsec > 0) {
            builder.addRunListener(new DelayInjector(args.delayMsec));
        } else if (args.logOnly && Build.VERSION.SDK_INT < 16) {
            builder.addRunListener(new DelayInjector(15));
        }
    }

    private void addListenersFromArg(RunnerArgs args, TestExecutor.Builder builder) {
        for (RunListener listener : args.listeners) {
            builder.addRunListener(listener);
        }
    }

    @Override
    public boolean onException(Object obj, Throwable e) {
        InstrumentationResultPrinter instResultPrinter = this.getInstrumentationResultPrinter();
        if (instResultPrinter != null) {
            instResultPrinter.reportProcessCrash(e);
        }
        return super.onException(obj, e);
    }

    TestRequest buildRequest(RunnerArgs runnerArgs, Bundle bundleArgs) {
        UsageTracker tracker;
        TestRequestBuilder builder = this.createTestRequestBuilder((Instrumentation)this, bundleArgs);
        builder.addApkToScan(this.getContext().getPackageCodePath());
        builder.addFromRunnerArgs(runnerArgs);
        if (!runnerArgs.disableAnalytics && null != this.getTargetContext() && null != (tracker = new AnalyticsBasedUsageTracker.Builder(this.getTargetContext()).buildIfPossible())) {
            UsageTrackerRegistry.registerInstance(tracker);
        }
        return builder.build();
    }

    TestRequestBuilder createTestRequestBuilder(Instrumentation instr, Bundle arguments) {
        return new TestRequestBuilder(instr, arguments);
    }
}

