/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.sdk;

import com.android.SdkConstants;
import com.android.builder.internal.FakeAndroidTarget;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;

public class PlatformLoader
implements SdkLoader {
    private static PlatformLoader sLoader;
    private final File mTreeLocation;
    private File mHostToolsFolder;
    private SdkInfo mSdkInfo;
    private final ImmutableList<File> mRepositories;

    public static synchronized SdkLoader getLoader(File treeLocation) {
        if (sLoader == null) {
            sLoader = new PlatformLoader(treeLocation);
        } else if (!treeLocation.equals(PlatformLoader.sLoader.mTreeLocation)) {
            throw new IllegalStateException("Already created an SDK Loader with different SDK Path");
        }
        return sLoader;
    }

    public static synchronized void unload() {
        sLoader = null;
    }

    @Override
    public TargetInfo getTargetInfo(String targetHash, Revision buildToolRevision, ILogger logger) {
        this.init(logger);
        FakeAndroidTarget androidTarget = new FakeAndroidTarget(this.mTreeLocation.getPath(), targetHash);
        File hostTools = this.getHostToolsFolder();
        BuildToolInfo buildToolInfo = new BuildToolInfo(buildToolRevision, this.mTreeLocation, new File(hostTools, SdkConstants.FN_AAPT), new File(hostTools, SdkConstants.FN_AIDL), new File(this.mTreeLocation, "prebuilts/sdk/tools/dx"), new File(this.mTreeLocation, "prebuilts/sdk/tools/lib/dx.jar"), new File(hostTools, SdkConstants.FN_RENDERSCRIPT), new File(this.mTreeLocation, "prebuilts/sdk/renderscript/include"), new File(this.mTreeLocation, "prebuilts/sdk/renderscript/clang-include"), new File(hostTools, SdkConstants.FN_BCC_COMPAT), new File(hostTools, "arm-linux-androideabi-ld"), new File(hostTools, "aarch64-linux-android-ld"), new File(hostTools, "i686-linux-android-ld"), new File(hostTools, "mipsel-linux-android-ld"), new File(hostTools, SdkConstants.FN_ZIPALIGN));
        return new TargetInfo(androidTarget, buildToolInfo);
    }

    @Override
    public SdkInfo getSdkInfo(ILogger logger) {
        this.init(logger);
        return this.mSdkInfo;
    }

    @Override
    public ImmutableList<File> getRepositories() {
        return this.mRepositories;
    }

    private PlatformLoader(File treeLocation) {
        this.mTreeLocation = treeLocation;
        this.mRepositories = ImmutableList.of((Object)new File(this.mTreeLocation + "/prebuilts/sdk/m2repository"));
    }

    private synchronized void init(ILogger logger) {
        if (this.mSdkInfo == null) {
            String host;
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                host = "darwin-x86";
            } else if (SdkConstants.CURRENT_PLATFORM == 1) {
                host = "linux-x86";
            } else {
                throw new IllegalStateException("Windows is not supported for platform development");
            }
            this.mSdkInfo = new SdkInfo(new File(this.mTreeLocation, "out/host/" + host + "/framework/annotations.jar"), new File(this.mTreeLocation, "out/host/" + host + "/bin/adb"));
        }
    }

    private synchronized File getHostToolsFolder() {
        if (this.mHostToolsFolder == null) {
            File tools = new File(this.mTreeLocation, "prebuilts/sdk/tools");
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                this.mHostToolsFolder = new File(tools, "darwin/bin");
            } else if (SdkConstants.CURRENT_PLATFORM == 1) {
                this.mHostToolsFolder = new File(tools, "linux/bin");
            } else {
                throw new IllegalStateException("Windows is not supported for platform development");
            }
            if (!this.mHostToolsFolder.isDirectory()) {
                throw new IllegalStateException("Host tools folder missing: " + this.mHostToolsFolder.getAbsolutePath());
            }
        }
        return this.mHostToolsFolder;
    }
}

