/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.GenerateMainDexListCommand;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class GenerateMainDexList {
    private static final String VERSION = "v0.2.0";
    private final Timing timing = new Timing("maindex");
    private final InternalOptions options;

    private GenerateMainDexList(InternalOptions options) {
        this.options = options;
    }

    private List<String> run(AndroidApp app) throws IOException, ExecutionException {
        ExecutorService executor = ThreadUtils.getExecutorService(this.options);
        DexApplication application = new ApplicationReader(app, this.options, this.timing).read(executor);
        AppInfoWithSubtyping appInfo = new AppInfoWithSubtyping(application);
        RootSetBuilder.RootSet mainDexRootSet = new RootSetBuilder(application, appInfo, (List<ProguardConfigurationRule>)this.options.mainDexKeepRules).run(executor);
        Set<DexType> mainDexBaseClasses = new Enqueuer(appInfo).traceMainDex(mainDexRootSet, this.timing);
        Set<DexType> mainDexClasses = new MainDexListBuilder(mainDexBaseClasses, application).run();
        List<String> result = mainDexClasses.stream().map(c -> c.toSourceString().replace('.', '/') + ".class").sorted().collect(Collectors.toList());
        if (this.options.printMainDexListFile != null) {
            try (OutputStream mainDexOut = Files.newOutputStream(this.options.printMainDexListFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                PrintWriter writer = new PrintWriter(mainDexOut);
                result.forEach(writer::println);
                writer.flush();
            }
        }
        return result;
    }

    public static List<String> run(GenerateMainDexListCommand command) throws IOException, ExecutionException {
        ExecutorService executorService = ThreadUtils.getExecutorService(command.getInternalOptions());
        try {
            List<String> list = GenerateMainDexList.run(command, executorService);
            return list;
        }
        finally {
            executorService.shutdown();
        }
    }

    public static List<String> run(GenerateMainDexListCommand command, ExecutorService executor) throws IOException, ExecutionException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        return new GenerateMainDexList(options).run(app);
    }

    public static void main(String[] args) throws IOException, ProguardRuleParserException, CompilationException, ExecutionException {
        GenerateMainDexListCommand.Builder builder = GenerateMainDexListCommand.parse(args);
        GenerateMainDexListCommand command = builder.build();
        if (command.isPrintHelp()) {
            System.out.println(GenerateMainDexListCommand.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("MainDexListGenerator v0.2.0");
            return;
        }
        List<String> result = GenerateMainDexList.run(command);
        if (command.getMainDexListOutputPath() == null) {
            result.forEach(System.out::println);
        }
    }
}

