/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeSuperRange;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import java.util.List;

public class InvokeSuper
extends InvokeMethodWithReceiver {
    public InvokeSuper(DexMethod target, Value result, List<Value> arguments) {
        super(target, result, arguments);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.SUPER;
    }

    @Override
    protected String getTypeString() {
        return "Super";
    }

    @Override
    public DexEncodedMethod computeSingleTarget(AppInfoWithSubtyping appInfo) {
        return appInfo.lookupDirectTarget(this.getInvokedMethod());
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeSuperRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeSuper(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        if (!other.isInvokeSuper()) {
            return false;
        }
        return super.identicalNonValueParts(other);
    }

    @Override
    public boolean isInvokeSuper() {
        return true;
    }

    @Override
    public InvokeSuper asInvokeSuper() {
        return this;
    }

    @Override
    DexEncodedMethod lookupTarget(AppInfo appInfo) {
        DexMethod method = this.getInvokedMethod();
        return appInfo.lookupVirtualDefinition(method.holder, method);
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.SAMECLASS;
    }
}

