/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.MonitorEnter;
import com.android.tools.r8.code.MonitorExit;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;

public class Monitor
extends Instruction {
    private final Type type;

    public Monitor(Type type, Value object) {
        super(null, object);
        this.type = type;
    }

    private Value object() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int object = builder.argumentOrAllocateRegister(this.object(), this.getNumber());
        if (object > this.maxInValueRegister()) {
            object = builder.allocatedRegister(this.object(), this.getNumber());
        }
        if (this.type == Type.ENTER) {
            builder.add((Instruction)this, new MonitorEnter(object));
        } else {
            builder.add((Instruction)this, new MonitorExit(object));
        }
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        return other.asMonitor().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asMonitor().type.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Monitor defines no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isMonitor() {
        return true;
    }

    @Override
    public Monitor asMonitor() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.NEVER;
    }

    public static enum Type {
        ENTER,
        EXIT;

    }
}

