/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ReasonPrinter;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Enqueuer {
    private final AppInfoWithSubtyping appInfo;
    private RootSetBuilder.RootSet rootSet;
    private Map<DexType, Set<DexMethod>> virtualInvokes = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexMethod>> superInvokes = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexMethod>> directInvokes = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexMethod>> staticInvokes = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexField>> instanceFieldsWritten = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexField>> instanceFieldsRead = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexField>> staticFieldsRead = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexField>> staticFieldsWritten = Maps.newIdentityHashMap();
    private final List<SemanticsProvider> extensions = new ArrayList<SemanticsProvider>();
    private final Map<Class, Object> extensionsState = new HashMap<Class, Object>();
    private Map<DexType, SetWithReason<DexEncodedMethod>> reachableVirtualMethods = Maps.newIdentityHashMap();
    private Map<DexEncodedMethod, Set<DexEncodedMethod>> superInvokeDependencies = Maps.newIdentityHashMap();
    private Map<DexType, SetWithReason<DexEncodedField>> reachableInstanceFields = Maps.newIdentityHashMap();
    private Set<DexType> liveTypes = Sets.newIdentityHashSet();
    private SetWithReason<DexType> instantiatedTypes = new SetWithReason();
    private SetWithReason<DexEncodedMethod> targetedMethods = new SetWithReason();
    private SetWithReason<DexEncodedMethod> liveMethods = new SetWithReason();
    private SetWithReason<DexEncodedField> liveFields = new SetWithReason();
    private Queue<Action> workList = Queues.newArrayDeque();
    private Set<DexMethod> virtualTargetsMarkedAsReachable = Sets.newIdentityHashSet();
    private Set<DexItem> reportedMissing = Sets.newIdentityHashSet();
    private Set<DexItem> pinnedItems = Sets.newIdentityHashSet();
    private final Map<DexType, Set<DexAnnotation>> deferredAnnotations = new IdentityHashMap<DexType, Set<DexAnnotation>>();

    public Enqueuer(AppInfoWithSubtyping appInfo) {
        this.appInfo = appInfo;
    }

    public void addExtension(SemanticsProvider extension) {
        this.extensions.add(extension);
    }

    private void enqueueRootItems(Map<DexItem, ProguardKeepRule> items) {
        this.workList.addAll(items.entrySet().stream().map(Action::forRootItem).collect(Collectors.toList()));
        this.pinnedItems.addAll(items.keySet());
    }

    private <S extends DexItem, T extends Descriptor<S, T>> boolean registerItemWithTarget(Map<DexType, Set<T>> seen, T item) {
        DexType holder = item.getHolder();
        if (holder.isArrayType()) {
            holder = holder.toBaseType(this.appInfo.dexItemFactory);
        }
        if (!holder.isClassType()) {
            return false;
        }
        this.markTypeAsLive(holder);
        return seen.computeIfAbsent(item.getHolder(), ignore -> Sets.newIdentityHashSet()).add(item);
    }

    private void markTypeAsLive(DexType type) {
        assert (type.isClassType());
        if (this.liveTypes.add(type)) {
            Set<DexAnnotation> annotations;
            DexClass holder = this.appInfo.definitionFor(type);
            if (holder == null) {
                this.reportMissingClass(type);
                return;
            }
            for (DexType iface : holder.interfaces.values) {
                this.markTypeAsLive(iface);
            }
            if (holder.superType != null) {
                this.markTypeAsLive(holder.superType);
            }
            if (!holder.annotations.isEmpty()) {
                this.processAnnotations(holder.annotations.annotations);
            }
            if (holder.hasNonTrivialClassInitializer()) {
                DexEncodedMethod clinit = holder.getClassInitializer();
                this.markDirectStaticOrConstructorMethodAsLive(clinit, KeepReason.reachableFromLiveType(type));
            }
            if ((annotations = this.deferredAnnotations.remove(type)) != null) {
                annotations.forEach(this::handleAnnotationOfLiveType);
            }
        }
    }

    private void handleAnnotationOfLiveType(DexAnnotation annotation) {
        AnnotationReferenceMarker referenceMarker = new AnnotationReferenceMarker(annotation.annotation.type, this.appInfo.dexItemFactory);
        annotation.annotation.collectIndexedItems(referenceMarker);
    }

    private void processAnnotations(DexAnnotation[] annotations) {
        for (DexAnnotation annotation : annotations) {
            DexType type = annotation.annotation.type;
            if (this.liveTypes.contains(type)) {
                this.handleAnnotationOfLiveType(annotation);
                continue;
            }
            this.deferredAnnotations.computeIfAbsent(type, ignore -> new HashSet()).add(annotation);
        }
    }

    private void handleInvokeOfStaticTarget(DexMethod method, KeepReason reason) {
        DexEncodedMethod encodedMethod = this.appInfo.lookupStaticTarget(method);
        if (encodedMethod == null) {
            this.reportMissingMethod(method);
            return;
        }
        this.markDirectStaticOrConstructorMethodAsLive(encodedMethod, reason);
    }

    private void handleInvokeOfDirectTarget(DexMethod method, KeepReason reason) {
        DexEncodedMethod encodedMethod = this.appInfo.lookupDirectTarget(method);
        if (encodedMethod == null) {
            this.reportMissingMethod(method);
            return;
        }
        this.markDirectStaticOrConstructorMethodAsLive(encodedMethod, reason);
    }

    private void reportMissingClass(DexType clazz) {
    }

    private void reportMissingMethod(DexMethod method) {
    }

    private void reportMissingField(DexField field) {
    }

    private void markMethodAsTargeted(DexEncodedMethod encodedMethod, KeepReason reason) {
        this.markTypeAsLive(encodedMethod.method.holder);
        this.targetedMethods.add(encodedMethod, reason);
    }

    private void processNewlyInstantiatedClass(DexClass clazz, KeepReason reason) {
        if (!this.instantiatedTypes.add(clazz.type, reason)) {
            return;
        }
        this.markTypeAsLive(clazz.type);
        this.transitionMethodsForInstantiatedClass(clazz.type);
        this.transitionFieldsForInstantiatedClass(clazz.type);
        this.enqueueRootItems(this.rootSet.getDependentItems(clazz.type));
    }

    private void transitionMethodsForInstantiatedClass(DexType type) {
        DexClass clazz;
        HashSet<Equivalence.Wrapper> seen = new HashSet<Equivalence.Wrapper>();
        MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        do {
            if ((clazz = this.appInfo.definitionFor(type)) == null) {
                this.reportMissingClass(type);
                break;
            }
            SetWithReason<DexEncodedMethod> reachableMethods = this.reachableVirtualMethods.get(type);
            if (reachableMethods == null) continue;
            for (DexEncodedMethod encodedMethod : reachableMethods.getItems()) {
                Equivalence.Wrapper ignoringClass = equivalence.wrap(encodedMethod.method);
                if (seen.contains(ignoringClass)) continue;
                seen.add(ignoringClass);
                this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(type));
            }
        } while ((type = clazz.superType) != null && !this.instantiatedTypes.contains(type));
    }

    private void transitionFieldsForInstantiatedClass(DexType type) {
        DexClass clazz;
        do {
            if ((clazz = this.appInfo.definitionFor(type)) == null) {
                this.reportMissingClass(type);
                break;
            }
            SetWithReason<DexEncodedField> reachableFields = this.reachableInstanceFields.get(type);
            if (reachableFields == null) continue;
            for (DexEncodedField field : reachableFields.getItems()) {
                this.markInstanceFieldAsLive(field, KeepReason.reachableFromLiveType(type));
            }
        } while ((type = clazz.superType) != null && !this.instantiatedTypes.contains(type));
    }

    private void markStaticFieldAsLive(DexField field, KeepReason reason) {
        this.markTypeAsLive(field.clazz);
        DexEncodedField encodedField = this.appInfo.lookupStaticTarget(field.clazz, field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return;
        }
        this.liveFields.add(encodedField, reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(encodedField));
    }

    private void markInstanceFieldAsLive(DexEncodedField field, KeepReason reason) {
        assert (field != null);
        this.markTypeAsLive(field.field.clazz);
        this.liveFields.add(field, reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(field));
    }

    private void markDirectStaticOrConstructorMethodAsLive(DexEncodedMethod encodedMethod, KeepReason reason) {
        assert (encodedMethod != null);
        if (!this.liveMethods.contains(encodedMethod)) {
            this.markTypeAsLive(encodedMethod.method.holder);
            this.markMethodAsTargeted(encodedMethod, reason);
            this.workList.add(Action.markMethodLive(encodedMethod, reason));
        }
    }

    private void markVirtualMethodAsLive(DexEncodedMethod method, KeepReason reason) {
        assert (method != null);
        if (!this.liveMethods.contains(method)) {
            this.workList.add(Action.markMethodLive(method, reason));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInstantiatedOrHasInstantiatedSubtype(DexType type) {
        if (this.instantiatedTypes.contains(type)) return true;
        if (!this.appInfo.subtypes(type).stream().anyMatch(this.instantiatedTypes::contains)) return false;
        return true;
    }

    private void markFieldAsReachable(DexField field, KeepReason reason) {
        DexEncodedField encodedField = this.appInfo.lookupInstanceTarget(field.clazz, field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return;
        }
        SetWithReason reachable = this.reachableInstanceFields.computeIfAbsent(encodedField.field.clazz, ignore -> new SetWithReason());
        if (reachable.add(encodedField, reason) && this.isInstantiatedOrHasInstantiatedSubtype(encodedField.field.clazz)) {
            this.markInstanceFieldAsLive(encodedField, reason);
        }
    }

    private void markVirtualMethodAsReachable(DexMethod method, boolean interfaceInvoke, KeepReason reason) {
        Set<DexEncodedMethod> targets;
        if (!this.virtualTargetsMarkedAsReachable.add(method)) {
            return;
        }
        if (method.holder.isArrayType()) {
            DexType baseType = method.holder.toBaseType(this.appInfo.dexItemFactory);
            if (baseType.isClassType()) {
                this.markTypeAsLive(baseType);
            }
            return;
        }
        DexClass holder = this.appInfo.definitionFor(method.holder);
        if (holder == null) {
            this.reportMissingClass(method.holder);
            return;
        }
        DexEncodedMethod topTarget = this.appInfo.lookupVirtualDefinition(method.holder, method);
        if (topTarget == null) {
            this.reportMissingMethod(method);
            return;
        }
        this.markMethodAsTargeted(topTarget, reason);
        if (interfaceInvoke) {
            if (!holder.isInterface()) {
                throw new CompilationError("InvokeInterface on non-interface method " + method.toSourceString() + ".");
            }
            targets = this.appInfo.lookupInterfaceTargets(method);
        } else {
            if (holder.isInterface()) {
                throw new CompilationError("InvokeVirtual on interface method " + method.toSourceString() + ".");
            }
            targets = this.appInfo.lookupVirtualTargets(method);
        }
        block0: for (DexEncodedMethod encodedMethod : targets) {
            SetWithReason reachable = this.reachableVirtualMethods.computeIfAbsent(encodedMethod.method.holder, ignore -> new SetWithReason());
            if (!reachable.add(encodedMethod, reason) || !this.isInstantiatedOrHasInstantiatedSubtype(encodedMethod.method.holder)) continue;
            if (this.instantiatedTypes.contains(encodedMethod.method.holder)) {
                this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(encodedMethod.method.holder));
                continue;
            }
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            Enqueuer.fillWorkList(worklist, encodedMethod.method.holder);
            while (!worklist.isEmpty()) {
                DexType current = (DexType)worklist.pollFirst();
                DexClass currentHolder = this.appInfo.definitionFor(current);
                if (currentHolder == null || currentHolder.findVirtualTarget(encodedMethod.method) != null) continue;
                if (this.instantiatedTypes.contains(current)) {
                    this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(current));
                    continue block0;
                }
                Enqueuer.fillWorkList(worklist, current);
            }
        }
    }

    private static void fillWorkList(Deque<DexType> worklist, DexType type) {
        if (type.isInterface()) {
            type.forAllImplementsSubtypes(worklist::addLast);
            type.forAllExtendsSubtypes(worklist::addLast);
        } else {
            type.forAllExtendsSubtypes(worklist::addLast);
        }
    }

    private void markSuperMethodAsReachable(DexMethod method, DexEncodedMethod from) {
        DexEncodedMethod target = this.appInfo.lookupVirtualTarget(method.holder, method);
        if (target == null) {
            this.reportMissingMethod(method);
            return;
        }
        assert (!this.superInvokeDependencies.containsKey(from) || !this.superInvokeDependencies.get(from).contains(target));
        this.superInvokeDependencies.computeIfAbsent(from, ignore -> Sets.newIdentityHashSet()).add(target);
        if (this.liveMethods.contains(from)) {
            this.markMethodAsTargeted(target, KeepReason.invokedViaSuperFrom(from));
            this.markVirtualMethodAsLive(target, KeepReason.invokedViaSuperFrom(from));
        }
    }

    public ReasonPrinter getReasonPrinter(Set<DexItem> queriedItems) {
        if (queriedItems.isEmpty()) {
            return ReasonPrinter.getNoOpPrinter();
        }
        HashMap<DexItem, KeepReason> reachability = new HashMap<DexItem, KeepReason>();
        for (SetWithReason<DexEncodedMethod> setWithReason : this.reachableVirtualMethods.values()) {
            reachability.putAll(setWithReason.getReasons());
        }
        for (SetWithReason<KeyedDexItem> setWithReason : this.reachableInstanceFields.values()) {
            reachability.putAll(setWithReason.getReasons());
        }
        return new ReasonPrinter(queriedItems, this.liveFields.getReasons(), this.liveMethods.getReasons(), reachability, this.instantiatedTypes.getReasons());
    }

    public Set<DexType> traceMainDex(RootSetBuilder.RootSet rootSet, Timing timing) {
        this.rootSet = rootSet;
        this.enqueueRootItems(rootSet.noShrinking);
        AppInfoWithLiveness appInfo = this.trace(timing);
        return new HashSet<DexType>(appInfo.liveTypes);
    }

    public AppInfoWithLiveness traceApplication(RootSetBuilder.RootSet rootSet, Timing timing) {
        this.rootSet = rootSet;
        this.enqueueRootItems(rootSet.noShrinking);
        this.appInfo.libraryClasses().forEach(this::markAllVirtualMethodsReachable);
        return this.trace(timing);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AppInfoWithLiveness trace(Timing timing) {
        timing.begin("Grow the tree.");
        try {
            block13: while (!this.workList.isEmpty()) {
                Action action = this.workList.poll();
                switch (action.kind) {
                    case MARK_INSTANTIATED: {
                        this.processNewlyInstantiatedClass((DexClass)action.target, action.reason);
                        continue block13;
                    }
                    case MARK_REACHABLE_FIELD: {
                        this.markFieldAsReachable((DexField)action.target, action.reason);
                        continue block13;
                    }
                    case MARK_REACHABLE_VIRTUAL: {
                        this.markVirtualMethodAsReachable((DexMethod)action.target, false, action.reason);
                        continue block13;
                    }
                    case MARK_REACHABLE_INTERFACE: {
                        this.markVirtualMethodAsReachable((DexMethod)action.target, true, action.reason);
                        continue block13;
                    }
                    case MARK_REACHABLE_SUPER: {
                        this.markSuperMethodAsReachable((DexMethod)action.target, (DexEncodedMethod)action.context);
                        continue block13;
                    }
                    case MARK_METHOD_KEPT: {
                        this.markMethodAsKept((DexEncodedMethod)action.target, action.reason);
                        continue block13;
                    }
                    case MARK_FIELD_KEPT: {
                        this.markFieldAsKept((DexEncodedField)action.target, action.reason);
                        continue block13;
                    }
                    case MARK_METHOD_LIVE: {
                        this.processNewlyLiveMethod((DexEncodedMethod)action.target, action.reason);
                        continue block13;
                    }
                }
                throw new IllegalArgumentException(action.kind.toString());
            }
            assert (this.liveTypes.stream().allMatch(DexType::isClassType));
            if ($assertionsDisabled) return new AppInfoWithLiveness(this.appInfo, this);
            if (this.instantiatedTypes.getItems().stream().allMatch(DexType::isClassType)) return new AppInfoWithLiveness(this.appInfo, this);
            throw new AssertionError();
        }
        finally {
            timing.end();
        }
    }

    private void markMethodAsKept(DexEncodedMethod target, KeepReason reason) {
        DexClass holder = this.appInfo.definitionFor(target.method.holder);
        if (holder == null) {
            return;
        }
        if (!(target.accessFlags.isStatic() || target.accessFlags.isConstructor() || target.accessFlags.isPrivate())) {
            this.markVirtualMethodAsReachable(target.method, holder.accessFlags.isInterface(), reason);
        } else {
            this.markDirectStaticOrConstructorMethodAsLive(target, reason);
        }
    }

    private void markFieldAsKept(DexEncodedField target, KeepReason reason) {
        if (this.appInfo.definitionFor(target.field.clazz) == null) {
            return;
        }
        if (target.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(target.field, reason);
        } else {
            this.markFieldAsReachable(target.field, reason);
        }
    }

    private void markAllVirtualMethodsReachable(DexClass clazz) {
        for (DexEncodedMethod encodedMethod : clazz.virtualMethods()) {
            this.markMethodAsTargeted(encodedMethod, KeepReason.isLibraryMethod());
            this.markVirtualMethodAsReachable(encodedMethod.method, clazz.isInterface(), KeepReason.isLibraryMethod());
        }
    }

    private void processNewlyLiveMethod(DexEncodedMethod method, KeepReason reason) {
        if (this.liveMethods.add(method, reason)) {
            DexClass holder = this.appInfo.definitionFor(method.method.holder);
            assert (holder != null);
            if (holder.isLibraryClass()) {
                return;
            }
            Set<DexEncodedMethod> superCallTargets = this.superInvokeDependencies.get(method);
            if (superCallTargets != null) {
                for (DexEncodedMethod superCallTarget : superCallTargets) {
                    this.markMethodAsTargeted(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                    this.markVirtualMethodAsLive(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                }
            }
            this.processAnnotations(method.annotations.annotations);
            for (DexAnnotationSet parameterAnnotation : method.parameterAnnotations.values) {
                this.processAnnotations(parameterAnnotation.annotations);
            }
            boolean processed = false;
            if (!this.extensions.isEmpty()) {
                for (SemanticsProvider extension : this.extensions) {
                    if (!extension.appliesTo(method)) continue;
                    assert (this.extensions.stream().filter(e -> e.appliesTo(method)).count() == 1L);
                    this.extensionsState.put(extension.getClass(), extension.processMethod(method, new UseRegistry(method), this.extensionsState.get(extension.getClass())));
                    processed = true;
                }
            }
            if (!processed) {
                method.registerReachableDefinitions(new UseRegistry(method));
            }
            this.enqueueRootItems(this.rootSet.getDependentItems(method));
        }
    }

    private Set<DexField> collectFields(Map<DexType, Set<DexField>> map) {
        return map.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    SortedSet<DexField> collectInstanceFieldsRead() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.collectFields(this.instanceFieldsRead));
    }

    SortedSet<DexField> collectInstanceFieldsWritten() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.collectFields(this.instanceFieldsWritten));
    }

    SortedSet<DexField> collectStaticFieldsRead() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.collectFields(this.staticFieldsRead));
    }

    SortedSet<DexField> collectStaticFieldsWritten() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.collectFields(this.staticFieldsWritten));
    }

    private Set<DexField> collectReachedFields(Map<DexType, Set<DexField>> map, Function<DexField, DexField> lookup) {
        return map.values().stream().flatMap(set -> set.stream().map(lookup)).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    private DexField tryLookupInstanceField(DexField field) {
        DexEncodedField target = this.appInfo.lookupInstanceTarget(field.clazz, field);
        return target == null ? field : target.field;
    }

    private DexField tryLookupStaticField(DexField field) {
        DexEncodedField target = this.appInfo.lookupStaticTarget(field.clazz, field);
        return target == null ? field : target.field;
    }

    SortedSet<DexField> collectFieldsRead() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, (Collection)Sets.union(this.collectReachedFields(this.instanceFieldsRead, this::tryLookupInstanceField), this.collectReachedFields(this.staticFieldsRead, this::tryLookupStaticField)));
    }

    SortedSet<DexField> collectFieldsWritten() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, (Collection)Sets.union(this.collectReachedFields(this.instanceFieldsWritten, this::tryLookupInstanceField), this.collectReachedFields(this.staticFieldsWritten, this::tryLookupStaticField)));
    }

    public static interface SemanticsProvider {
        public boolean appliesTo(DexEncodedMethod var1);

        public Object processMethod(DexEncodedMethod var1, com.android.tools.r8.graph.UseRegistry var2, Object var3);
    }

    private class AnnotationReferenceMarker
    implements IndexedItemCollection {
        private final DexItem annotationHolder;
        private final DexItemFactory dexItemFactory;

        private AnnotationReferenceMarker(DexItem annotationHolder, DexItemFactory dexItemFactory) {
            this.annotationHolder = annotationHolder;
            this.dexItemFactory = dexItemFactory;
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            DexClass holder = Enqueuer.this.appInfo.definitionFor(field.clazz);
            if (holder == null) {
                return false;
            }
            DexEncodedField target = holder.findStaticTarget(field);
            if (target != null) {
                if (target.field == field) {
                    Enqueuer.this.markStaticFieldAsLive(field, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.findInstanceTarget(field);
                if (target != null && target.field != field) {
                    Enqueuer.this.markFieldAsReachable(field, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            DexClass holder = Enqueuer.this.appInfo.definitionFor(method.holder);
            if (holder == null) {
                return false;
            }
            DexEncodedMethod target = holder.findDirectTarget(method);
            if (target != null) {
                if (target.method == method) {
                    Enqueuer.this.markDirectStaticOrConstructorMethodAsLive(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.findVirtualTarget(method);
                if (target != null && target.method == method) {
                    Enqueuer.this.markMethodAsTargeted(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return false;
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            if (type != this.dexItemFactory.voidType) {
                Enqueuer.this.markTypeAsLive(type);
            }
            return false;
        }
    }

    private static class SetWithReason<T> {
        private final Set<T> items = Sets.newIdentityHashSet();
        private final Map<T, KeepReason> reasons = Maps.newIdentityHashMap();

        private SetWithReason() {
        }

        boolean add(T item, KeepReason reason) {
            if (this.items.add(item)) {
                this.reasons.put(item, reason);
                return true;
            }
            return false;
        }

        boolean contains(T item) {
            return this.items.contains(item);
        }

        Set<T> getItems() {
            return ImmutableSet.copyOf(this.items);
        }

        Map<T, KeepReason> getReasons() {
            return ImmutableMap.copyOf(this.reasons);
        }
    }

    public static class AppInfoWithLiveness
    extends AppInfoWithSubtyping {
        public final SortedSet<DexType> liveTypes;
        final SortedSet<DexType> instantiatedTypes;
        final SortedSet<DexMethod> targetedMethods;
        final SortedSet<DexMethod> liveMethods;
        public final SortedSet<DexField> liveFields;
        public final SortedSet<DexField> fieldsRead;
        public final SortedSet<DexField> fieldsWritten;
        public final SortedSet<DexField> instanceFieldReads;
        public final SortedSet<DexField> instanceFieldWrites;
        public final SortedSet<DexField> staticFieldReads;
        public final SortedSet<DexField> staticFieldWrites;
        public final SortedSet<DexMethod> virtualInvokes;
        public final SortedSet<DexMethod> superInvokes;
        public final SortedSet<DexMethod> directInvokes;
        public final SortedSet<DexMethod> staticInvokes;
        public final Set<DexItem> pinnedItems;
        public final Map<DexItem, ProguardMemberRule> noSideEffects;
        public final Map<DexItem, ProguardMemberRule> assumedValues;
        public final Set<DexItem> alwaysInline;
        public final Map<Class, Object> extensions;

        private AppInfoWithLiveness(AppInfoWithSubtyping appInfo, Enqueuer enqueuer) {
            super(appInfo);
            this.liveTypes = ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, (Collection)enqueuer.liveTypes);
            this.instantiatedTypes = ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.instantiatedTypes.getItems());
            this.targetedMethods = this.toDescriptorSet(enqueuer.targetedMethods.getItems());
            this.liveMethods = this.toDescriptorSet(enqueuer.liveMethods.getItems());
            this.liveFields = this.toDescriptorSet(enqueuer.liveFields.getItems());
            this.instanceFieldReads = enqueuer.collectInstanceFieldsRead();
            this.instanceFieldWrites = enqueuer.collectInstanceFieldsWritten();
            this.staticFieldReads = enqueuer.collectStaticFieldsRead();
            this.staticFieldWrites = enqueuer.collectStaticFieldsWritten();
            this.fieldsRead = enqueuer.collectFieldsRead();
            this.fieldsWritten = enqueuer.collectFieldsWritten();
            this.pinnedItems = ImmutableSet.copyOf((Collection)enqueuer.pinnedItems);
            this.virtualInvokes = this.joinInvokedMethods(enqueuer.virtualInvokes);
            this.superInvokes = this.joinInvokedMethods(enqueuer.superInvokes);
            this.directInvokes = this.joinInvokedMethods(enqueuer.directInvokes);
            this.staticInvokes = this.joinInvokedMethods(enqueuer.staticInvokes);
            this.noSideEffects = ((Enqueuer)enqueuer).rootSet.noSideEffects;
            this.assumedValues = ((Enqueuer)enqueuer).rootSet.assumedValues;
            this.alwaysInline = ((Enqueuer)enqueuer).rootSet.alwaysInline;
            this.extensions = enqueuer.extensionsState;
            assert (Sets.intersection(this.instanceFieldReads, this.staticFieldReads).size() == 0);
            assert (Sets.intersection(this.instanceFieldWrites, this.staticFieldWrites).size() == 0);
        }

        private AppInfoWithLiveness(AppInfoWithLiveness previous, DexApplication application) {
            super(application);
            this.liveTypes = previous.liveTypes;
            this.instantiatedTypes = previous.instantiatedTypes;
            this.targetedMethods = previous.targetedMethods;
            this.liveMethods = previous.liveMethods;
            this.liveFields = previous.liveFields;
            this.instanceFieldReads = previous.instanceFieldReads;
            this.instanceFieldWrites = previous.instanceFieldWrites;
            this.staticFieldReads = previous.staticFieldReads;
            this.staticFieldWrites = previous.staticFieldWrites;
            this.fieldsRead = previous.fieldsRead;
            this.fieldsWritten = previous.fieldsWritten;
            this.pinnedItems = previous.pinnedItems;
            this.noSideEffects = previous.noSideEffects;
            this.assumedValues = previous.assumedValues;
            this.virtualInvokes = previous.virtualInvokes;
            this.superInvokes = previous.superInvokes;
            this.directInvokes = previous.directInvokes;
            this.staticInvokes = previous.staticInvokes;
            this.extensions = previous.extensions;
            this.alwaysInline = previous.alwaysInline;
            assert (Sets.intersection(this.instanceFieldReads, this.staticFieldReads).size() == 0);
            assert (Sets.intersection(this.instanceFieldWrites, this.staticFieldWrites).size() == 0);
        }

        private AppInfoWithLiveness(AppInfoWithLiveness previous, GraphLense lense) {
            super(previous, lense);
            this.liveTypes = previous.liveTypes;
            this.instantiatedTypes = AppInfoWithLiveness.rewriteItems(previous.instantiatedTypes, lense::lookupType);
            this.targetedMethods = AppInfoWithLiveness.rewriteItems(previous.targetedMethods, lense::lookupMethod);
            this.liveMethods = AppInfoWithLiveness.rewriteItems(previous.liveMethods, lense::lookupMethod);
            this.liveFields = AppInfoWithLiveness.rewriteItems(previous.liveFields, lense::lookupField);
            this.instanceFieldReads = AppInfoWithLiveness.rewriteItems(previous.instanceFieldReads, lense::lookupField);
            this.instanceFieldWrites = AppInfoWithLiveness.rewriteItems(previous.instanceFieldWrites, lense::lookupField);
            this.staticFieldReads = AppInfoWithLiveness.rewriteItems(previous.staticFieldReads, lense::lookupField);
            this.staticFieldWrites = AppInfoWithLiveness.rewriteItems(previous.staticFieldWrites, lense::lookupField);
            this.fieldsRead = AppInfoWithLiveness.rewriteItems(previous.fieldsRead, lense::lookupField);
            this.fieldsWritten = AppInfoWithLiveness.rewriteItems(previous.fieldsWritten, lense::lookupField);
            this.pinnedItems = previous.pinnedItems;
            this.noSideEffects = previous.noSideEffects;
            this.assumedValues = previous.assumedValues;
            this.virtualInvokes = AppInfoWithLiveness.rewriteItems(previous.virtualInvokes, lense::lookupMethod);
            this.superInvokes = AppInfoWithLiveness.rewriteItems(previous.superInvokes, lense::lookupMethod);
            this.directInvokes = AppInfoWithLiveness.rewriteItems(previous.directInvokes, lense::lookupMethod);
            this.staticInvokes = AppInfoWithLiveness.rewriteItems(previous.staticInvokes, lense::lookupMethod);
            this.alwaysInline = previous.alwaysInline;
            this.extensions = previous.extensions;
            assert (Sets.intersection(this.instanceFieldReads, this.staticFieldReads).size() == 0);
            assert (Sets.intersection(this.instanceFieldWrites, this.staticFieldWrites).size() == 0);
        }

        private SortedSet<DexMethod> joinInvokedMethods(Map<DexType, Set<DexMethod>> invokes) {
            ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
            invokes.values().forEach(arg_0 -> ((ImmutableSortedSet.Builder)builder).addAll(arg_0));
            return builder.build();
        }

        private <T extends PresortedComparable<T>> SortedSet<T> toDescriptorSet(Set<? extends KeyedDexItem<T>> set) {
            ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompareTo);
            for (KeyedDexItem<T> item : set) {
                builder.add(item.getKey());
            }
            return builder.build();
        }

        private static <T extends PresortedComparable<T>> ImmutableSortedSet<T> rewriteItems(Set<T> original, BiFunction<T, DexEncodedMethod, T> rewrite) {
            ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
            for (PresortedComparable item : original) {
                builder.add(rewrite.apply(item, null));
            }
            return builder.build();
        }

        public <T> T getExtension(Class extension, T defaultValue) {
            if (this.extensions.containsKey(extension)) {
                return (T)this.extensions.get(extension);
            }
            return defaultValue;
        }

        public <T> void setExtension(Class extension, T value) {
            assert (!this.extensions.containsKey(extension));
            this.extensions.put(extension, value);
        }

        @Override
        public boolean hasLiveness() {
            return true;
        }

        @Override
        public AppInfoWithLiveness withLiveness() {
            return this;
        }

        public AppInfoWithLiveness prunedCopyFrom(DexApplication application) {
            return new AppInfoWithLiveness(this, application);
        }

        public AppInfoWithLiveness rewrittenWithLense(GraphLense lense) {
            assert (lense.isContextFree());
            return new AppInfoWithLiveness(this, lense);
        }
    }

    private static class Action {
        final Kind kind;
        final DexItem target;
        final DexItem context;
        final KeepReason reason;

        private Action(Kind kind, DexItem target, DexItem context, KeepReason reason) {
            this.kind = kind;
            this.target = target;
            this.context = context;
            this.reason = reason;
        }

        public static Action markReachableVirtual(DexMethod method, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_VIRTUAL, method, null, reason);
        }

        public static Action markReachableInterface(DexMethod method, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_INTERFACE, method, null, reason);
        }

        public static Action markReachableSuper(DexMethod method, DexEncodedMethod from) {
            return new Action(Kind.MARK_REACHABLE_SUPER, method, from, null);
        }

        public static Action markReachableField(DexField field, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_FIELD, field, null, reason);
        }

        public static Action markInstantiated(DexClass clazz, KeepReason reason) {
            return new Action(Kind.MARK_INSTANTIATED, clazz, null, reason);
        }

        public static Action markMethodLive(DexEncodedMethod method, KeepReason reason) {
            return new Action(Kind.MARK_METHOD_LIVE, method, null, reason);
        }

        public static Action markMethodKept(DexEncodedMethod method, KeepReason reason) {
            return new Action(Kind.MARK_METHOD_KEPT, method, null, reason);
        }

        public static Action markFieldKept(DexEncodedField method, KeepReason reason) {
            return new Action(Kind.MARK_FIELD_KEPT, method, null, reason);
        }

        public static Action forRootItem(Map.Entry<DexItem, ProguardKeepRule> root) {
            DexItem item = root.getKey();
            KeepReason reason = KeepReason.dueToKeepRule(root.getValue());
            if (item instanceof DexClass) {
                return Action.markInstantiated((DexClass)item, reason);
            }
            if (item instanceof DexEncodedField) {
                return Action.markFieldKept((DexEncodedField)item, reason);
            }
            if (item instanceof DexEncodedMethod) {
                return Action.markMethodKept((DexEncodedMethod)item, reason);
            }
            throw new IllegalArgumentException(item.toString());
        }

        private static enum Kind {
            MARK_REACHABLE_VIRTUAL,
            MARK_REACHABLE_INTERFACE,
            MARK_REACHABLE_SUPER,
            MARK_REACHABLE_FIELD,
            MARK_INSTANTIATED,
            MARK_METHOD_LIVE,
            MARK_METHOD_KEPT,
            MARK_FIELD_KEPT;

        }
    }

    private class UseRegistry
    extends com.android.tools.r8.graph.UseRegistry {
        private final DexEncodedMethod currentMethod;

        private UseRegistry(DexEncodedMethod currentMethod) {
            this.currentMethod = currentMethod;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.virtualInvokes, method)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableVirtual(method, KeepReason.invokedFrom(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.directInvokes, method)) {
                return false;
            }
            Enqueuer.this.handleInvokeOfDirectTarget(method, KeepReason.invokedFrom(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.staticInvokes, method)) {
                return false;
            }
            Enqueuer.this.handleInvokeOfStaticTarget(method, KeepReason.invokedFrom(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.virtualInvokes, method)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableInterface(method, KeepReason.invokedFrom(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.superInvokes, method)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableSuper(method, this.currentMethod));
            return true;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.instanceFieldsWritten, field)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableField(field, KeepReason.fieldReferencedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.instanceFieldsRead, field)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableField(field, KeepReason.fieldReferencedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            if (Enqueuer.this.instantiatedTypes.contains(type)) {
                return false;
            }
            DexClass clazz = Enqueuer.this.appInfo.definitionFor(type);
            if (clazz == null) {
                Enqueuer.this.reportMissingClass(type);
                return false;
            }
            Enqueuer.this.workList.add(Action.markInstantiated(clazz, KeepReason.instantiatedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.staticFieldsRead, field)) {
                return false;
            }
            Enqueuer.this.markStaticFieldAsLive(field, KeepReason.fieldReferencedIn(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.staticFieldsWritten, field)) {
                return false;
            }
            Enqueuer.this.markStaticFieldAsLive(field, KeepReason.fieldReferencedIn(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            DexType baseType = type.toBaseType(((Enqueuer)Enqueuer.this).appInfo.dexItemFactory);
            if (baseType.isClassType()) {
                Enqueuer.this.markTypeAsLive(baseType);
                return true;
            }
            return false;
        }
    }
}

