/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeSource {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeSource.class);
    private static Map<String, DateTimeFormatter> dateTimeFormatterMap = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static final ZoneOffset ZONE_OFFSET = ZoneOffset.of("+8");
    private static final DateTimeSource instance = new DateTimeSource();

    private DateTimeSource() {
    }

    public static DateTimeSource getInstance() {
        return instance;
    }

    public String randomDate(int year, String pattern) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pattern), (Object)"\u65e5\u671f\u683c\u5f0f\u4e3a\u7a7a");
        Preconditions.checkArgument((year >= 1970 && year <= 9999 ? 1 : 0) != 0, (Object)"\u5e74\u4efd\u65e0\u6548");
        boolean isLeapYear = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        LocalDate begin = LocalDate.of(year, 1, 1);
        LocalDate date = begin.plusDays(RandomUtils.nextInt((int)0, (int)(isLeapYear ? 366 : 365)));
        return date.format(dateTimeFormatterMap.computeIfAbsent(pattern, k -> DateTimeFormatter.ofPattern(pattern)));
    }

    public String randomDate(LocalDate beginDate, LocalDate endDate, String pattern) {
        Preconditions.checkArgument((beginDate != null && endDate != null ? 1 : 0) != 0, (Object)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)beginDate.isBefore(endDate), (Object)"\u65e5\u671f\u8303\u56f4\u65e0\u6548");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pattern), (Object)"\u65e5\u671f\u683c\u5f0f\u4e3a\u7a7a");
        long diff = ChronoUnit.DAYS.between(beginDate, endDate);
        LocalDate date = beginDate.plusDays(RandomUtils.nextLong((long)0L, (long)(diff + 1L)));
        return date.format(dateTimeFormatterMap.computeIfAbsent(pattern, k -> DateTimeFormatter.ofPattern(pattern)));
    }

    public String randomFutureDate(LocalDate baseDate, String pattern) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pattern), (Object)"\u65e5\u671f\u683c\u5f0f\u4e3a\u7a7a");
        LocalDate date = baseDate.plusDays(RandomUtils.nextLong((long)1L, (long)99999L));
        return date.format(dateTimeFormatterMap.computeIfAbsent(pattern, k -> DateTimeFormatter.ofPattern(pattern)));
    }

    public String randomFutureDate(String pattern) {
        return this.randomFutureDate(LocalDate.now(), pattern);
    }

    public String randomPastDate(LocalDate baseDate, long maxDays, String pattern) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)pattern), (Object)"\u65e5\u671f\u683c\u5f0f\u4e3a\u7a7a");
        Preconditions.checkArgument((maxDays > 1L ? 1 : 0) != 0, (Object)"\u6700\u5927\u65e5\u671f\u95f4\u9694\u65e0\u6548");
        LocalDate date = baseDate.plusDays(-1L * RandomUtils.nextLong((long)1L, (long)(maxDays + 1L)));
        return date.format(dateTimeFormatterMap.computeIfAbsent(pattern, k -> DateTimeFormatter.ofPattern(pattern)));
    }

    public String randomPastDate(LocalDate baseDate, String pattern) {
        return this.randomPastDate(baseDate, 365L, pattern);
    }

    public String randomPastDate(String pattern) {
        return this.randomPastDate(LocalDate.now(), pattern);
    }

    public LocalDateTime randomTime(int year, int month, int dayOfMonth) {
        Preconditions.checkArgument((month >= 1 && month <= 12 ? 1 : 0) != 0, (Object)"\u6708\u4efd\u9519\u8bef");
        int hour = RandomUtils.nextInt((int)0, (int)24);
        int minute = RandomUtils.nextInt((int)0, (int)60);
        int second = RandomUtils.nextInt((int)0, (int)60);
        int millisecond = RandomUtils.nextInt((int)0, (int)1000);
        return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, millisecond);
    }

    public LocalDateTime randomPastTime(int maxDays) {
        Preconditions.checkArgument((maxDays >= 1 ? 1 : 0) != 0, (Object)"\u6700\u5927\u65e5\u671f\u95f4\u9694\u5fc5\u987b\u5927\u4e8e0");
        return this.randomPastTime(LocalDateTime.now(), maxDays * 86400);
    }

    public LocalDateTime randomPastTime(LocalDateTime base, long maxSeconds) {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"\u57fa\u51c6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        long second = maxSeconds > 1L ? RandomUtils.nextLong((long)0L, (long)(maxSeconds + 1L)) : RandomUtils.nextLong();
        long millisecond = RandomUtils.nextLong((long)0L, (long)1000L);
        return base.minus(second, ChronoUnit.SECONDS).minus(millisecond, ChronoUnit.MILLIS);
    }

    public LocalDateTime randomFutureTime(int maxDays) {
        Preconditions.checkArgument((maxDays >= 1 ? 1 : 0) != 0, (Object)"\u6700\u5927\u65e5\u671f\u95f4\u9694\u5fc5\u987b\u5927\u4e8e0");
        return this.randomFutureTime(LocalDateTime.now(), maxDays * 86400);
    }

    public LocalDateTime randomFutureTime(LocalDateTime base, long maxSeconds) {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"\u57fa\u51c6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        long second = maxSeconds > 1L ? RandomUtils.nextLong((long)0L, (long)(maxSeconds + 1L)) : RandomUtils.nextLong();
        long millisecond = RandomUtils.nextLong((long)0L, (long)1000L);
        return base.plus(second, ChronoUnit.SECONDS).plus(millisecond, ChronoUnit.MILLIS);
    }

    public long randomTimestamp(LocalDateTime begin, LocalDateTime end) {
        Preconditions.checkArgument((begin != null && end != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)begin.isBefore(end), (Object)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4");
        Duration duration = Duration.between(begin, end);
        long millis = duration.toMillis();
        return begin.toInstant(ZONE_OFFSET).toEpochMilli() + RandomUtils.nextLong((long)0L, (long)millis);
    }

    public long randomFutureTimestamp(LocalDateTime base, long maxSeconds) {
        return this.randomTimestamp(base, maxSeconds);
    }

    public long randomPastTimestamp(LocalDateTime base, long maxSeconds) {
        return this.randomTimestamp(base, maxSeconds > 0L ? -1L * maxSeconds : maxSeconds);
    }

    public long randomTimestamp(LocalDate date) {
        Preconditions.checkArgument((date != null ? 1 : 0) != 0, (Object)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        LocalDateTime begin = date.atStartOfDay();
        LocalDateTime end = date.plusDays(1L).atStartOfDay();
        return this.randomTimestamp(begin, end);
    }

    public String randomTimezoneName() {
        Set<String> zoneIds = ZoneId.getAvailableZoneIds();
        Object[] array = zoneIds.toArray();
        return Objects.toString(array[RandomUtils.nextInt((int)0, (int)array.length)]);
    }

    private long randomTimestamp(LocalDateTime base, long maxSeconds) {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"\u57fa\u51c6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((Math.abs(maxSeconds) > 1L ? 1 : 0) != 0, (Object)"\u76f8\u5dee\u79d2\u6570\u5fc5\u987b\u5927\u4e8e1");
        long diff = maxSeconds > 0L ? RandomUtils.nextLong((long)1L, (long)(maxSeconds * 1000L + 1L)) : -1L * RandomUtils.nextLong((long)1L, (long)(Math.abs(maxSeconds) * 1000L + 1L));
        return base.toInstant(ZONE_OFFSET).toEpochMilli() + diff;
    }
}

