/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.apifan.common.random.constant.CompetitionType;
import com.apifan.common.random.constant.FootballConfederation;
import com.apifan.common.random.entity.FootballTeam;
import com.apifan.common.random.util.ResourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SportSource {
    private static final Logger logger = LoggerFactory.getLogger(SportSource.class);
    private static List<String> FOOTBALL_PREMIER_LEAGUE = Lists.newArrayList();
    private static List<String> FOOTBALL_LA_LIGA = Lists.newArrayList();
    private static List<String> FOOTBALL_BUNDESLIGA = Lists.newArrayList();
    private static List<String> FOOTBALL_SERIE_A = Lists.newArrayList();
    private static List<String> FOOTBALL_LIGUE_1 = Lists.newArrayList();
    private static List<String> FOOTBALL_EREDIVISIE = Lists.newArrayList();
    private static List<String> BASKETBALL_NBA = Lists.newArrayList();
    private static List<String> BASKETBALL_CBA = Lists.newArrayList();
    private static final List<FootballTeam> FIFA_MEMBER_LIST = Lists.newArrayList();
    private static final SportSource instance = new SportSource();

    private SportSource() {
        FOOTBALL_PREMIER_LEAGUE = ResourceUtils.readLines("football-premier-league.txt");
        FOOTBALL_LA_LIGA = ResourceUtils.readLines("football-la-liga.txt");
        FOOTBALL_BUNDESLIGA = ResourceUtils.readLines("football-bundesliga.txt");
        FOOTBALL_SERIE_A = ResourceUtils.readLines("football-serie-a.txt");
        FOOTBALL_LIGUE_1 = ResourceUtils.readLines("football-ligue-1.txt");
        FOOTBALL_EREDIVISIE = ResourceUtils.readLines("football-eredivisie.txt");
        BASKETBALL_NBA = ResourceUtils.readLines("basketball-nba.txt");
        BASKETBALL_CBA = ResourceUtils.readLines("basketball-cba.txt");
        List<String> fifaMemberInfoList = ResourceUtils.readLines("fifa-members.txt");
        if (CollectionUtils.isNotEmpty(fifaMemberInfoList)) {
            fifaMemberInfoList.forEach(e -> {
                if (StringUtils.isBlank((CharSequence)e)) {
                    return;
                }
                String[] tmp = e.split(",");
                if (tmp.length == 5) {
                    FootballTeam fm = new FootballTeam();
                    fm.setName(tmp[0]);
                    fm.setNameEn(tmp[1]);
                    fm.setCode(tmp[2]);
                    fm.setConfederation(tmp[3]);
                    fm.setConfederationName(tmp[4]);
                    FIFA_MEMBER_LIST.add(fm);
                }
            });
        }
    }

    public static SportSource getInstance() {
        return instance;
    }

    public String randomFootballTeam(CompetitionType competition) {
        Preconditions.checkArgument((competition != null ? 1 : 0) != 0, (Object)"\u5fc5\u987b\u4f20\u5165\u8db3\u7403\u8054\u8d5b\u7c7b\u578b");
        if (CompetitionType.PREMIER_LEAGUE.equals((Object)competition)) {
            return ResourceUtils.getRandomElement(FOOTBALL_PREMIER_LEAGUE);
        }
        if (CompetitionType.LA_LIGA.equals((Object)competition)) {
            return ResourceUtils.getRandomElement(FOOTBALL_LA_LIGA);
        }
        if (CompetitionType.BUNDESLIGA.equals((Object)competition)) {
            return ResourceUtils.getRandomElement(FOOTBALL_BUNDESLIGA);
        }
        if (CompetitionType.SERIE_A.equals((Object)competition)) {
            return ResourceUtils.getRandomElement(FOOTBALL_SERIE_A);
        }
        if (CompetitionType.LIGUE_1.equals((Object)competition)) {
            return ResourceUtils.getRandomElement(FOOTBALL_LIGUE_1);
        }
        if (CompetitionType.EREDIVISIE.equals((Object)competition)) {
            return ResourceUtils.getRandomElement(FOOTBALL_EREDIVISIE);
        }
        throw new RuntimeException("\u672a\u77e5\u7684\u8db3\u7403\u8054\u8d5b\u7c7b\u578b");
    }

    public String randomBasketballTeam(CompetitionType competition) {
        Preconditions.checkArgument((competition != null ? 1 : 0) != 0, (Object)"\u5fc5\u987b\u4f20\u5165\u7bee\u7403\u8054\u8d5b\u7c7b\u578b");
        if (CompetitionType.NBA.equals((Object)competition)) {
            return ResourceUtils.getRandomElement(BASKETBALL_NBA);
        }
        if (CompetitionType.CBA.equals((Object)competition)) {
            return ResourceUtils.getRandomElement(BASKETBALL_CBA);
        }
        throw new RuntimeException("\u672a\u77e5\u7684\u7bee\u7403\u8054\u8d5b\u7c7b\u578b");
    }

    public FootballTeam randomFootballTeam(FootballConfederation confederation) {
        Preconditions.checkNotNull((Object)((Object)confederation), (Object)"\u8bf7\u4f20\u5165\u76f8\u5e94\u7684\u8db3\u7403\u8054\u5408\u4f1a\u53c2\u6570");
        return (FootballTeam)ResourceUtils.getRandomElement(FIFA_MEMBER_LIST.stream().filter(i -> Objects.equals(confederation.getName(), i.getConfederationName())).collect(Collectors.toList()));
    }

    public FootballTeam randomFootballTeam() {
        return ResourceUtils.getRandomElement(FIFA_MEMBER_LIST);
    }
}

