/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.ffmpegkit;

import android.util.Log;
import com.arthenica.ffmpegkit.MediaInformation;
import com.arthenica.ffmpegkit.StreamInformation;
import com.arthenica.smartexception.java.Exceptions;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaInformationJsonParser {
    public static MediaInformation from(String ffprobeJsonOutput) {
        try {
            return MediaInformationJsonParser.fromWithError(ffprobeJsonOutput);
        }
        catch (JSONException e) {
            Log.e((String)"ffmpeg-kit", (String)String.format("MediaInformation parsing failed.%s", Exceptions.getStackTraceString((Throwable)e)));
            return null;
        }
    }

    public static MediaInformation fromWithError(String ffprobeJsonOutput) throws JSONException {
        JSONObject jsonObject = new JSONObject(ffprobeJsonOutput);
        JSONArray streamArray = jsonObject.optJSONArray("streams");
        ArrayList<StreamInformation> arrayList = new ArrayList<StreamInformation>();
        for (int i = 0; streamArray != null && i < streamArray.length(); ++i) {
            JSONObject streamObject = streamArray.optJSONObject(i);
            if (streamObject == null) continue;
            arrayList.add(new StreamInformation(streamObject));
        }
        return new MediaInformation(jsonObject, arrayList);
    }
}

