/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.mobileffmpeg;

import android.os.AsyncTask;
import com.arthenica.mobileffmpeg.AbiDetect;
import com.arthenica.mobileffmpeg.AsyncFFmpegExecuteTask;
import com.arthenica.mobileffmpeg.Config;
import com.arthenica.mobileffmpeg.ExecuteCallback;
import com.arthenica.mobileffmpeg.FFmpegExecution;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class FFmpeg {
    static final long DEFAULT_EXECUTION_ID = 0L;
    private static final AtomicLong executionIdCounter = new AtomicLong(3000L);

    private FFmpeg() {
    }

    public static int execute(String[] arguments) {
        return Config.ffmpegExecute(0L, arguments);
    }

    public static long executeAsync(String[] arguments, ExecuteCallback executeCallback) {
        long newExecutionId = executionIdCounter.incrementAndGet();
        AsyncFFmpegExecuteTask asyncFFmpegExecuteTask = new AsyncFFmpegExecuteTask(newExecutionId, arguments, executeCallback);
        asyncFFmpegExecuteTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return newExecutionId;
    }

    public static long executeAsync(String[] arguments, ExecuteCallback executeCallback, Executor executor) {
        long newExecutionId = executionIdCounter.incrementAndGet();
        AsyncFFmpegExecuteTask asyncFFmpegExecuteTask = new AsyncFFmpegExecuteTask(newExecutionId, arguments, executeCallback);
        asyncFFmpegExecuteTask.executeOnExecutor(executor, new Void[0]);
        return newExecutionId;
    }

    public static int execute(String command, String delimiter) {
        String[] stringArray;
        if (command == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = command.split(delimiter == null ? " " : delimiter);
        }
        return FFmpeg.execute(stringArray);
    }

    public static int execute(String command) {
        return FFmpeg.execute(FFmpeg.parseArguments(command));
    }

    public static long executeAsync(String command, ExecuteCallback executeCallback) {
        long newExecutionId = executionIdCounter.incrementAndGet();
        AsyncFFmpegExecuteTask asyncFFmpegExecuteTask = new AsyncFFmpegExecuteTask(newExecutionId, command, executeCallback);
        asyncFFmpegExecuteTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return newExecutionId;
    }

    public static long executeAsync(String command, ExecuteCallback executeCallback, Executor executor) {
        long newExecutionId = executionIdCounter.incrementAndGet();
        AsyncFFmpegExecuteTask asyncFFmpegExecuteTask = new AsyncFFmpegExecuteTask(newExecutionId, command, executeCallback);
        asyncFFmpegExecuteTask.executeOnExecutor(executor, new Void[0]);
        return newExecutionId;
    }

    public static void cancel() {
        Config.nativeFFmpegCancel(0L);
    }

    public static void cancel(long executionId) {
        Config.nativeFFmpegCancel(executionId);
    }

    public static List<FFmpegExecution> listExecutions() {
        return Config.listFFmpegExecutions();
    }

    static String[] parseArguments(String command) {
        ArrayList<String> argumentList = new ArrayList<String>();
        StringBuilder currentArgument = new StringBuilder();
        boolean singleQuoteStarted = false;
        boolean doubleQuoteStarted = false;
        for (int i = 0; i < command.length(); ++i) {
            Character previousChar = i > 0 ? Character.valueOf(command.charAt(i - 1)) : null;
            char currentChar = command.charAt(i);
            if (currentChar == ' ') {
                if (singleQuoteStarted || doubleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                if (currentArgument.length() <= 0) continue;
                argumentList.add(currentArgument.toString());
                currentArgument = new StringBuilder();
                continue;
            }
            if (currentChar == '\'' && (previousChar == null || previousChar.charValue() != '\\')) {
                if (singleQuoteStarted) {
                    singleQuoteStarted = false;
                    continue;
                }
                if (doubleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                singleQuoteStarted = true;
                continue;
            }
            if (currentChar == '\"' && (previousChar == null || previousChar.charValue() != '\\')) {
                if (doubleQuoteStarted) {
                    doubleQuoteStarted = false;
                    continue;
                }
                if (singleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                doubleQuoteStarted = true;
                continue;
            }
            currentArgument.append(currentChar);
        }
        if (currentArgument.length() > 0) {
            argumentList.add(currentArgument.toString());
        }
        return argumentList.toArray(new String[0]);
    }

    static String argumentsToString(String[] arguments) {
        if (arguments == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(arguments[i]);
        }
        return stringBuilder.toString();
    }

    static {
        AbiDetect.class.getName();
        Config.class.getName();
    }
}

