/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.mobileffmpeg;

import android.util.Log;
import com.arthenica.mobileffmpeg.AbiDetect;
import com.arthenica.mobileffmpeg.Config;
import com.arthenica.mobileffmpeg.FFmpeg;
import com.arthenica.mobileffmpeg.MediaInformation;
import com.arthenica.mobileffmpeg.MediaInformationParser;

public class FFprobe {
    private FFprobe() {
    }

    public static int execute(String[] arguments) {
        int lastReturnCode = Config.nativeFFprobeExecute(arguments);
        Config.setLastReturnCode(lastReturnCode);
        return lastReturnCode;
    }

    public static int execute(String command) {
        return FFprobe.execute(FFmpeg.parseArguments(command));
    }

    public static MediaInformation getMediaInformation(String path) {
        return FFprobe.getMediaInformationFromCommandArguments(new String[]{"-v", "error", "-hide_banner", "-print_format", "json", "-show_format", "-show_streams", "-i", path});
    }

    public static MediaInformation getMediaInformationFromCommand(String command) {
        return FFprobe.getMediaInformationFromCommandArguments(FFmpeg.parseArguments(command));
    }

    public static MediaInformation getMediaInformation(String path, Long timeout) {
        return FFprobe.getMediaInformation(path);
    }

    private static MediaInformation getMediaInformationFromCommandArguments(String[] arguments) {
        int rc = FFprobe.execute(arguments);
        if (rc == 0) {
            return MediaInformationParser.from(Config.getLastCommandOutput());
        }
        Log.w((String)"mobile-ffmpeg", (String)Config.getLastCommandOutput());
        return null;
    }

    static {
        AbiDetect.class.getName();
        Config.class.getName();
    }
}

