/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.mobileffmpeg;

import android.util.Log;
import com.arthenica.mobileffmpeg.MediaInformation;
import com.arthenica.mobileffmpeg.StreamInformation;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaInformationParser {
    public static MediaInformation from(String ffprobeJsonOutput) {
        try {
            return MediaInformationParser.fromWithError(ffprobeJsonOutput);
        }
        catch (JSONException e) {
            Log.e((String)"mobile-ffmpeg", (String)"MediaInformation parsing failed.", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static MediaInformation fromWithError(String ffprobeJsonOutput) throws JSONException {
        JSONObject jsonObject = new JSONObject(ffprobeJsonOutput);
        JSONArray streamArray = jsonObject.optJSONArray("streams");
        ArrayList<StreamInformation> arrayList = new ArrayList<StreamInformation>();
        for (int i = 0; streamArray != null && i < streamArray.length(); ++i) {
            JSONObject streamObject = streamArray.optJSONObject(i);
            if (streamObject == null) continue;
            arrayList.add(new StreamInformation(streamObject));
        }
        return new MediaInformation(jsonObject, arrayList);
    }
}

