/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigation;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;

public class AHBottomNavigationFABBehavior
extends CoordinatorLayout.Behavior<FloatingActionButton> {
    private int navigationBarHeight = 0;
    private long lastSnackbarUpdate = 0L;

    public AHBottomNavigationFABBehavior(int navigationBarHeight) {
        this.navigationBarHeight = navigationBarHeight;
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        if (dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            return true;
        }
        if (dependency != null && dependency instanceof AHBottomNavigation) {
            return true;
        }
        return super.layoutDependsOn(parent, (View)child, dependency);
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        this.updateFloatingActionButton(child, dependency);
        return super.onDependentViewChanged(parent, (View)child, dependency);
    }

    private void updateFloatingActionButton(FloatingActionButton child, View dependency) {
        if (child != null && dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            this.lastSnackbarUpdate = System.currentTimeMillis();
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int fabDefaultBottomMargin = p.bottomMargin;
            child.setY(dependency.getY() - (float)fabDefaultBottomMargin);
        } else if (child != null && dependency != null && dependency instanceof AHBottomNavigation) {
            if (System.currentTimeMillis() - this.lastSnackbarUpdate < 30L) {
                return;
            }
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int fabDefaultBottomMargin = p.bottomMargin;
            child.setY(dependency.getY() - (float)fabDefaultBottomMargin);
        }
    }
}

