/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;

public class AHBottomNavigationItem {
    private String title = "";
    private Drawable drawable;
    private int color = -7829368;
    @StringRes
    private int titleRes = 0;
    @DrawableRes
    private int drawableRes = 0;
    @ColorRes
    private int colorRes = 0;

    public AHBottomNavigationItem(String title, @DrawableRes int resource) {
        this.title = title;
        this.drawableRes = resource;
    }

    @Deprecated
    public AHBottomNavigationItem(String title, @DrawableRes int resource, @ColorRes int color2) {
        this.title = title;
        this.drawableRes = resource;
        this.color = color2;
    }

    public AHBottomNavigationItem(@StringRes int titleRes, @DrawableRes int drawableRes, @ColorRes int colorRes) {
        this.titleRes = titleRes;
        this.drawableRes = drawableRes;
        this.colorRes = colorRes;
    }

    public AHBottomNavigationItem(String title, Drawable drawable2) {
        this.title = title;
        this.drawable = drawable2;
    }

    public AHBottomNavigationItem(String title, Drawable drawable2, @ColorInt int color2) {
        this.title = title;
        this.drawable = drawable2;
        this.color = color2;
    }

    public String getTitle(Context context) {
        if (this.titleRes != 0) {
            return context.getString(this.titleRes);
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleRes = 0;
    }

    public void setTitle(@StringRes int titleRes) {
        this.titleRes = titleRes;
        this.title = "";
    }

    public int getColor(Context context) {
        if (this.colorRes != 0) {
            return ContextCompat.getColor((Context)context, (int)this.colorRes);
        }
        return this.color;
    }

    public void setColor(@ColorInt int color2) {
        this.color = color2;
        this.colorRes = 0;
    }

    public void setColorRes(@ColorRes int colorRes) {
        this.colorRes = colorRes;
        this.color = 0;
    }

    public Drawable getDrawable(Context context) {
        if (this.drawableRes != 0) {
            try {
                return AppCompatResources.getDrawable((Context)context, (int)this.drawableRes);
            }
            catch (Resources.NotFoundException e) {
                return ContextCompat.getDrawable((Context)context, (int)this.drawableRes);
            }
        }
        return this.drawable;
    }

    public void setDrawable(@DrawableRes int drawableRes) {
        this.drawableRes = drawableRes;
        this.drawable = null;
    }

    public void setDrawable(Drawable drawable2) {
        this.drawable = drawable2;
        this.drawableRes = 0;
    }
}

