/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.enums;

public enum XADataSourceEnum {
    MYSQL("com.mysql.cj.jdbc.MysqlXADataSource"),
    ORACLE("oracle.jdbc.xa.client.OracleXADataSource"),
    POSTGRE_SQL("org.postgresql.xa.PGXADataSource"),
    H2("org.h2.jdbcx.JdbcDataSource");

    private final String xaDriverClassName;

    private XADataSourceEnum(String xaDriverClassName) {
        this.xaDriverClassName = xaDriverClassName;
    }

    public static boolean contains(String xaDataSourceClassName) {
        for (XADataSourceEnum item : XADataSourceEnum.values()) {
            if (!item.getXaDriverClassName().equals(xaDataSourceClassName)) continue;
            return true;
        }
        return false;
    }

    public String getXaDriverClassName() {
        return this.xaDriverClassName;
    }
}

