/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Compare;
import com.baomidou.mybatisplus.core.conditions.interfaces.Func;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.conditions.interfaces.Nested;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.enums.WrapperKeyword;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.SerializationUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractWrapper<T, R, This extends AbstractWrapper<T, R, This>>
extends Wrapper<T>
implements Compare<This, R>,
Nested<This>,
Join<This>,
Func<This, R> {
    private static final String MP_GENERAL_PARAMNAME = "MPGENVAL";
    private static final String DEFAULT_PARAM_ALIAS = "ew";
    private static final String PLACE_HOLDER = "{%s}";
    private static final String MYBATIS_PLUS_TOKEN = "#{%s.paramNameValuePairs.%s}";
    protected final This typedThis = this;
    protected AtomicInteger paramNameSeq;
    protected Map<String, Object> paramNameValuePairs;
    protected String paramAlias = null;
    protected String lastSql = "";
    protected T entity;
    protected MergeSegments expression;
    protected Class<T> entityClass;

    @Override
    public T getEntity() {
        return this.entity;
    }

    public This setEntity(T entity) {
        this.entity = entity;
        this.initEntityClass();
        return this.typedThis;
    }

    protected void initEntityClass() {
        if (this.entity != null) {
            this.entityClass = this.entity.getClass();
        }
    }

    protected Class<T> getCheckEntityClass() {
        Assert.notNull(this.entityClass, "entityClass must not null,please set entity before use this method!");
        return this.entityClass;
    }

    @Override
    public <V> This allEq(boolean condition, Map<R, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (StringUtils.checkValNotNull(v)) {
                    this.eq(k, v);
                } else if (null2IsNull) {
                    this.isNull(k);
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public <V> This allEq(boolean condition, BiPredicate<R, V> filter, Map<R, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (filter.test(k, v)) {
                    if (StringUtils.checkValNotNull(v)) {
                        this.eq(k, v);
                    } else if (null2IsNull) {
                        this.isNull(k);
                    }
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public This eq(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.EQ, val);
    }

    @Override
    public This ne(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.NE, val);
    }

    @Override
    public This gt(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.GT, val);
    }

    @Override
    public This ge(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.GE, val);
    }

    @Override
    public This lt(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.LT, val);
    }

    @Override
    public This le(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.LE, val);
    }

    @Override
    public This like(boolean condition, R column, Object val) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.LIKE, () -> this.formatSql("{0}", "%" + val + "%"));
    }

    @Override
    public This notLike(boolean condition, R column, Object val) {
        return (This)((AbstractWrapper)this.not(condition)).like(condition, (Object)column, val);
    }

    @Override
    public This likeLeft(boolean condition, R column, Object val) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.LIKE, () -> this.formatSql("{0}", "%" + val));
    }

    @Override
    public This likeRight(boolean condition, R column, Object val) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.LIKE, () -> this.formatSql("{0}", val + "%"));
    }

    @Override
    public This between(boolean condition, R column, Object val1, Object val2) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.BETWEEN, () -> this.formatSql("{0}", val1), SqlKeyword.AND, () -> this.formatSql("{0}", val2));
    }

    @Override
    public This notBetween(boolean condition, R column, Object val1, Object val2) {
        return (This)((AbstractWrapper)this.not(condition)).between(condition, (Object)column, val1, val2);
    }

    @Override
    public This and(boolean condition, Function<This, This> func) {
        return ((AbstractWrapper)this.and(condition)).addNestedCondition(condition, func);
    }

    @Override
    public This or(boolean condition, Function<This, This> func) {
        return ((AbstractWrapper)this.or(condition)).addNestedCondition(condition, func);
    }

    @Override
    public This nested(boolean condition, Function<This, This> func) {
        return this.addNestedCondition(condition, func);
    }

    @Override
    public This or(boolean condition) {
        return this.doIt(condition, SqlKeyword.OR);
    }

    @Override
    public This apply(boolean condition, String applySql, Object ... value) {
        return this.doIt(condition, WrapperKeyword.APPLY, () -> this.formatSql(applySql, value));
    }

    @Override
    public This last(boolean condition, String lastSql) {
        if (condition) {
            this.lastSql = " " + lastSql;
        }
        return this.typedThis;
    }

    @Override
    public This exists(boolean condition, String existsSql) {
        return this.doIt(condition, SqlKeyword.EXISTS, () -> String.format("(%s)", existsSql));
    }

    @Override
    public This notExists(boolean condition, String notExistsSql) {
        return (This)((AbstractWrapper)this.not(condition)).exists(condition, notExistsSql);
    }

    @Override
    public This isNull(boolean condition, R column) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.IS_NULL);
    }

    @Override
    public This isNotNull(boolean condition, R column) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.IS_NOT_NULL);
    }

    @Override
    public This in(boolean condition, R column, Collection<?> value) {
        if (CollectionUtils.isEmpty(value)) {
            return this.typedThis;
        }
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.IN, this.inExpression(value));
    }

    @Override
    public This notIn(boolean condition, R column, Collection<?> value) {
        if (CollectionUtils.isEmpty(value)) {
            return this.typedThis;
        }
        return (This)((AbstractWrapper)this.not(condition)).in(condition, (Object)column, (Collection)value);
    }

    @Override
    public This inSql(boolean condition, R column, String inValue) {
        return this.doIt(condition, () -> this.columnToString(column), SqlKeyword.IN, () -> String.format("(%s)", inValue));
    }

    @Override
    public This notInSql(boolean condition, R column, String inValue) {
        return (This)((AbstractWrapper)this.not(condition)).inSql(condition, (Object)column, inValue);
    }

    @Override
    public This groupBy(boolean condition, R ... columns) {
        if (ArrayUtils.isEmpty(columns)) {
            return this.typedThis;
        }
        return this.doIt(condition, SqlKeyword.GROUP_BY, () -> this.columnsToString(columns));
    }

    @Override
    public This orderBy(boolean condition, boolean isAsc, R ... columns) {
        if (ArrayUtils.isEmpty(columns)) {
            return this.typedThis;
        }
        SqlKeyword mode = isAsc ? SqlKeyword.ASC : SqlKeyword.DESC;
        for (R column : columns) {
            this.doIt(condition, SqlKeyword.ORDER_BY, () -> this.columnToString(column), mode);
        }
        return this.typedThis;
    }

    @Override
    public This having(boolean condition, String sqlHaving, Object ... params) {
        return this.doIt(condition, SqlKeyword.HAVING, () -> this.formatSqlIfNeed(condition, sqlHaving, params));
    }

    protected This not(boolean condition) {
        return this.doIt(condition, SqlKeyword.NOT);
    }

    protected This and(boolean condition) {
        return this.doIt(condition, SqlKeyword.AND);
    }

    protected This addCondition(boolean condition, R column, SqlKeyword sqlKeyword, Object val) {
        return this.doIt(condition, () -> this.columnToString(column), sqlKeyword, () -> this.formatSql("{0}", val));
    }

    protected This addNestedCondition(boolean condition, Function<This, This> func) {
        return this.doIt(condition, WrapperKeyword.LEFT_BRACKET, (ISqlSegment)func.apply(this.instance(this.paramNameSeq, this.paramNameValuePairs)), WrapperKeyword.RIGHT_BRACKET);
    }

    protected abstract This instance(AtomicInteger var1, Map<String, Object> var2);

    protected final String formatSql(String sqlStr, Object ... params) {
        return this.formatSqlIfNeed(true, sqlStr, params);
    }

    protected final String formatSqlIfNeed(boolean need, String sqlStr, Object ... params) {
        if (!need || StringUtils.isEmpty(sqlStr)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty(params)) {
            for (int i = 0; i < params.length; ++i) {
                String genParamName = MP_GENERAL_PARAMNAME + this.paramNameSeq.incrementAndGet();
                sqlStr = sqlStr.replace(String.format(PLACE_HOLDER, i), String.format(MYBATIS_PLUS_TOKEN, this.getParamAlias(), genParamName));
                this.paramNameValuePairs.put(genParamName, params[i]);
            }
        }
        return sqlStr;
    }

    private ISqlSegment inExpression(Collection<?> value) {
        return () -> value.stream().map(i -> this.formatSql("{0}", i)).collect(Collectors.joining(",", "(", ")"));
    }

    protected final void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap<String, Object>(16);
        this.expression = new MergeSegments();
    }

    protected This doIt(boolean condition, ISqlSegment ... sqlSegments) {
        if (condition) {
            this.expression.add(sqlSegments);
        }
        return this.typedThis;
    }

    public String getParamAlias() {
        return StringUtils.isEmpty(this.paramAlias) ? DEFAULT_PARAM_ALIAS : this.paramAlias;
    }

    @Override
    public String getSqlSegment() {
        String sqlSegment = this.expression.getSqlSegment();
        if (StringUtils.isNotEmpty(sqlSegment)) {
            return sqlSegment + this.lastSql;
        }
        if (StringUtils.isNotEmpty(this.lastSql)) {
            return this.lastSql;
        }
        return null;
    }

    @Override
    public MergeSegments getExpression() {
        return this.expression;
    }

    public Map<String, Object> getParamNameValuePairs() {
        return this.paramNameValuePairs;
    }

    protected String columnsToString(R ... columns) {
        return Arrays.stream(columns).map(this::columnToString).collect(Collectors.joining(","));
    }

    protected abstract String columnToString(R var1);

    public This clone() {
        return (This)((AbstractWrapper)SerializationUtils.clone(this.typedThis));
    }
}

