/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.entity.suggest;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.entity.suggest.CompleteRestResponse;
import org.frameworkset.elasticsearch.handler.ElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.serial.ESClassType;
import org.frameworkset.elasticsearch.serial.ESSerialThreadLocal;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompleteElasticSearchResponseHandler
extends ElasticSearchResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(CompleteElasticSearchResponseHandler.class);

    public CompleteElasticSearchResponseHandler() {
    }

    public CompleteElasticSearchResponseHandler(ESTypeReferences<?, ?> types) {
        super(types);
    }

    public CompleteElasticSearchResponseHandler(ESClassType type) {
        super(type);
    }

    public CompleteElasticSearchResponseHandler(Class<?> type) {
        super(type);
    }

    @Override
    public RestResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            RestResponse searchResponse = null;
            if (entity != null) {
                try {
                    ESSerialThreadLocal.setESTypeReferences(this.types);
                    RestResponse restResponse = (RestResponse)super.converJson(entity, CompleteRestResponse.class);
                    return restResponse;
                }
                catch (Exception e) {
                    throw new ElasticSearchException(e);
                }
                finally {
                    ESSerialThreadLocal.clean();
                }
            }
            return searchResponse;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            throw new ElasticSearchException(EntityUtils.toString((HttpEntity)entity));
        }
        throw new ElasticSearchException("Unexpected response status: " + status);
    }
}

