/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager;

import android.content.Context;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.beloo.widget.chipslayoutmanager.ChipsLayoutManager;
import com.beloo.widget.chipslayoutmanager.IScrollingController;
import com.beloo.widget.chipslayoutmanager.ScrollingController;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.layouter.IStateFactory;

class HorizontalScrollingController
extends ScrollingController
implements IScrollingController {
    private ChipsLayoutManager layoutManager;

    HorizontalScrollingController(ChipsLayoutManager layoutManager, IStateFactory stateFactory, ScrollingController.IScrollerListener scrollerListener) {
        super(layoutManager, stateFactory, scrollerListener);
        this.layoutManager = layoutManager;
    }

    @Override
    public RecyclerView.SmoothScroller createSmoothScroller(@NonNull Context context, final int position, final int timeMs, final AnchorViewState anchor) {
        return new LinearSmoothScroller(context){

            public PointF computeScrollVectorForPosition(int targetPosition) {
                int visiblePosition = anchor.getPosition();
                return new PointF(position > visiblePosition ? 1.0f : -1.0f, 0.0f);
            }

            protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
                super.onTargetFound(targetView, state, action);
                int currentLeft = HorizontalScrollingController.this.layoutManager.getPaddingLeft();
                int desiredLeft = HorizontalScrollingController.this.layoutManager.getDecoratedLeft(targetView);
                int dx = desiredLeft - currentLeft;
                action.update(dx, 0, timeMs, (Interpolator)new LinearInterpolator());
            }
        };
    }

    @Override
    public boolean canScrollVertically() {
        return false;
    }

    @Override
    public boolean canScrollHorizontally() {
        this.canvas.findBorderViews();
        if (this.layoutManager.getChildCount() > 0) {
            int left = this.layoutManager.getDecoratedLeft(this.canvas.getLeftView());
            int right = this.layoutManager.getDecoratedRight(this.canvas.getRightView());
            if (this.canvas.getMinPositionOnScreen() == 0 && this.canvas.getMaxPositionOnScreen() == this.layoutManager.getItemCount() - 1 && left >= this.layoutManager.getPaddingLeft() && right <= this.layoutManager.getWidth() - this.layoutManager.getPaddingRight()) {
                return false;
            }
        } else {
            return false;
        }
        return this.layoutManager.isScrollingEnabledContract();
    }

    @Override
    void offsetChildren(int d) {
        this.layoutManager.offsetChildrenHorizontal(d);
    }
}

