/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager;

import android.content.Context;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.beloo.widget.chipslayoutmanager.ChipsLayoutManager;
import com.beloo.widget.chipslayoutmanager.IScrollingController;
import com.beloo.widget.chipslayoutmanager.ScrollingController;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.layouter.IStateFactory;

class VerticalScrollingController
extends ScrollingController
implements IScrollingController {
    private ChipsLayoutManager lm;

    VerticalScrollingController(ChipsLayoutManager layoutManager, IStateFactory stateFactory, ScrollingController.IScrollerListener scrollerListener) {
        super(layoutManager, stateFactory, scrollerListener);
        this.lm = layoutManager;
    }

    @Override
    public RecyclerView.SmoothScroller createSmoothScroller(@NonNull Context context, final int position, final int timeMs, final AnchorViewState anchor) {
        return new LinearSmoothScroller(context){

            public PointF computeScrollVectorForPosition(int targetPosition) {
                int visiblePosition = anchor.getPosition();
                return new PointF(0.0f, position > visiblePosition ? 1.0f : -1.0f);
            }

            protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
                super.onTargetFound(targetView, state, action);
                int desiredTop = VerticalScrollingController.this.lm.getPaddingTop();
                int currentTop = VerticalScrollingController.this.lm.getDecoratedTop(targetView);
                int dy = currentTop - desiredTop;
                action.update(0, dy, timeMs, (Interpolator)new LinearInterpolator());
            }
        };
    }

    @Override
    public boolean canScrollVertically() {
        this.canvas.findBorderViews();
        if (this.lm.getChildCount() > 0) {
            int top = this.lm.getDecoratedTop(this.canvas.getTopView());
            int bottom = this.lm.getDecoratedBottom(this.canvas.getBottomView());
            if (this.canvas.getMinPositionOnScreen() == 0 && this.canvas.getMaxPositionOnScreen() == this.lm.getItemCount() - 1 && top >= this.lm.getPaddingTop() && bottom <= this.lm.getHeight() - this.lm.getPaddingBottom()) {
                return false;
            }
        } else {
            return false;
        }
        return this.lm.isScrollingEnabledContract();
    }

    @Override
    public boolean canScrollHorizontally() {
        return false;
    }

    @Override
    void offsetChildren(int d) {
        this.lm.offsetChildrenVertical(d);
    }
}

