/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.cache;

import android.graphics.Rect;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.cache.CacheParcelableContainer;
import com.beloo.widget.chipslayoutmanager.cache.IViewCacheStorage;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;

class ViewCacheStorage
implements IViewCacheStorage {
    private static final String TAG = ViewCacheStorage.class.getSimpleName();
    private static final int SIZE_MAX_CACHE = 1000;
    private RecyclerView.LayoutManager layoutManager;
    private NavigableSet<Integer> startsRow = new TreeSet<Integer>();
    private NavigableSet<Integer> endsRow = new TreeSet<Integer>();
    private int maxCacheSize = 1000;
    private boolean isCachingEnabled;

    ViewCacheStorage(RecyclerView.LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        this.isCachingEnabled = true;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    @Override
    public boolean isCachingEnabled() {
        return this.isCachingEnabled;
    }

    @Override
    public int getStartOfRow(int positionInRow) {
        Integer integer = this.startsRow.floor(positionInRow);
        if (integer == null) {
            integer = positionInRow;
        }
        return integer;
    }

    @Override
    public boolean isPositionEndsRow(int position) {
        return this.endsRow.contains(position);
    }

    @Override
    public boolean isPositionStartsRow(int position) {
        return this.startsRow.contains(position);
    }

    @Override
    public void setCachingEnabled(boolean isEnabled) {
        if (this.isCachingEnabled == isEnabled) {
            return;
        }
        Log.i((String)TAG, (String)(isEnabled ? "caching enabled" : "caching disabled"));
        this.isCachingEnabled = isEnabled;
    }

    private void checkCacheSizeReached() {
        if (this.startsRow.size() > this.maxCacheSize) {
            this.startsRow.remove(this.startsRow.first());
        }
        if (this.endsRow.size() > this.maxCacheSize) {
            this.endsRow.remove(this.endsRow.first());
        }
    }

    @Override
    public void storeRow(List<Pair<Rect, View>> row) {
        if (this.isCachingEnabled && !row.isEmpty()) {
            Pair<Rect, View> firstPair = row.get(0);
            Pair<Rect, View> secondPair = row.get(row.size() - 1);
            int startPosition = this.layoutManager.getPosition((View)firstPair.second);
            int endPosition = this.layoutManager.getPosition((View)secondPair.second);
            this.checkCacheSizeReached();
            this.startsRow.add(startPosition);
            this.endsRow.add(endPosition);
        }
    }

    @Override
    public boolean isInCache(int position) {
        return this.startsRow.ceiling(position) != null || this.endsRow.ceiling(position) != null;
    }

    @Override
    public void purge() {
        this.startsRow.clear();
        this.endsRow.clear();
    }

    @Override
    public void purgeCacheToPosition(int position) {
        if (this.isCacheEmpty()) {
            return;
        }
        Log.d((String)TAG, (String)("cache purged to position " + position));
        Iterator removeIterator = this.startsRow.headSet(position).iterator();
        while (removeIterator.hasNext()) {
            removeIterator.next();
            removeIterator.remove();
        }
        removeIterator = this.endsRow.headSet(position).iterator();
        while (removeIterator.hasNext()) {
            removeIterator.next();
            removeIterator.remove();
        }
    }

    @Override
    public Integer getLastCachePosition() {
        if (this.isCacheEmpty()) {
            return null;
        }
        return (Integer)this.endsRow.last();
    }

    @Override
    public boolean isCacheEmpty() {
        return this.endsRow.isEmpty();
    }

    @Override
    public void purgeCacheFromPosition(int position) {
        if (this.isCacheEmpty()) {
            return;
        }
        Iterator<Integer> removeIterator = this.startsRow.tailSet(position, true).iterator();
        while (removeIterator.hasNext()) {
            removeIterator.next();
            removeIterator.remove();
        }
        Integer previous = this.startsRow.lower(position);
        previous = previous == null ? position : previous;
        removeIterator = this.endsRow.tailSet(previous, true).iterator();
        while (removeIterator.hasNext()) {
            removeIterator.next();
            removeIterator.remove();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return new CacheParcelableContainer(this.startsRow, this.endsRow);
    }

    @Override
    public void onRestoreInstanceState(@Nullable Parcelable parcelable) {
        if (parcelable == null) {
            return;
        }
        if (!(parcelable instanceof CacheParcelableContainer)) {
            throw new IllegalStateException("wrong parcelable passed");
        }
        CacheParcelableContainer container = (CacheParcelableContainer)parcelable;
        this.startsRow = container.getStartsRow();
        this.endsRow = container.getEndsRow();
    }
}

