/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.util.Pair;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractLayouter;

class RightLayouter
extends AbstractLayouter {
    private boolean isPurged;

    private RightLayouter(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    Rect createViewRect(View view) {
        Rect viewRect = new Rect(this.viewLeft, this.viewTop, this.viewLeft + this.getCurrentViewWidth(), this.viewTop + this.getCurrentViewHeight());
        this.viewTop = this.viewBottom = viewRect.bottom;
        this.viewRight = Math.max(this.viewRight, viewRect.right);
        return viewRect;
    }

    @Override
    boolean isReverseOrder() {
        return false;
    }

    @Override
    void onPreLayout() {
        if (!this.rowViews.isEmpty()) {
            if (!this.isPurged) {
                this.isPurged = true;
                this.getCacheStorage().purgeCacheFromPosition(this.getLayoutManager().getPosition((View)((Pair)this.rowViews.get((int)0)).second));
            }
            this.getCacheStorage().storeRow(this.rowViews);
        }
    }

    @Override
    void onAfterLayout() {
        this.viewLeft = this.getViewRight();
        this.viewTop = this.getCanvasTopBorder();
    }

    @Override
    boolean isAttachedViewFromNewRow(View view) {
        int leftOfCurrentView = this.getLayoutManager().getDecoratedLeft(view);
        int topOfCurrentView = this.getLayoutManager().getDecoratedTop(view);
        return this.viewRight <= leftOfCurrentView && topOfCurrentView < this.viewTop;
    }

    @Override
    void onInterceptAttachView(View view) {
        this.viewTop = this.getLayoutManager().getDecoratedBottom(view);
        this.viewLeft = this.getLayoutManager().getDecoratedLeft(view);
        this.viewRight = Math.max(this.viewRight, this.getLayoutManager().getDecoratedRight(view));
    }

    @Override
    public int getStartRowBorder() {
        return this.getViewLeft();
    }

    @Override
    public int getEndRowBorder() {
        return this.getViewRight();
    }

    @Override
    public int getRowLength() {
        return this.viewTop - this.getCanvasTopBorder();
    }

    public static final class Builder
    extends AbstractLayouter.Builder {
        private Builder() {
        }

        @Override
        @NonNull
        public RightLayouter createLayouter() {
            return new RightLayouter(this);
        }
    }
}

