/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChildViewsIterable;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;

abstract class Square
implements ICanvas {
    RecyclerView.LayoutManager lm;
    private ChildViewsIterable childViews;
    private View topView;
    private View bottomView;
    private View leftView;
    private View rightView;
    private Integer minPositionOnScreen;
    private Integer maxPositionOnScreen;
    private boolean isFirstItemAdded;

    Square(RecyclerView.LayoutManager lm) {
        this.lm = lm;
        this.childViews = new ChildViewsIterable(lm);
    }

    @Override
    public Rect getCanvasRect() {
        return new Rect(this.getCanvasLeftBorder(), this.getCanvasTopBorder(), this.getCanvasRightBorder(), this.getCanvasBottomBorder());
    }

    @Override
    public Rect getViewRect(View view) {
        int left = this.lm.getDecoratedLeft(view);
        int top = this.lm.getDecoratedTop(view);
        int right = this.lm.getDecoratedRight(view);
        int bottom = this.lm.getDecoratedBottom(view);
        return new Rect(left, top, right, bottom);
    }

    @Override
    public boolean isInside(Rect rectCandidate) {
        Rect intersect = new Rect(rectCandidate);
        return this.getCanvasRect().intersect(intersect);
    }

    @Override
    public boolean isInside(View viewCandidate) {
        return this.isInside(this.getViewRect(viewCandidate));
    }

    @Override
    public boolean isFullyVisible(View view) {
        Rect rect = this.getViewRect(view);
        return this.isFullyVisible(rect);
    }

    @Override
    public boolean isFullyVisible(Rect rect) {
        return rect.top >= this.getCanvasTopBorder() && rect.bottom <= this.getCanvasBottomBorder() && rect.left >= this.getCanvasLeftBorder() && rect.right <= this.getCanvasRightBorder();
    }

    @Override
    public void findBorderViews() {
        this.topView = null;
        this.bottomView = null;
        this.leftView = null;
        this.rightView = null;
        this.minPositionOnScreen = -1;
        this.maxPositionOnScreen = -1;
        this.isFirstItemAdded = false;
        if (this.lm.getChildCount() > 0) {
            View initView;
            this.topView = initView = this.lm.getChildAt(0);
            this.bottomView = initView;
            this.leftView = initView;
            this.rightView = initView;
            for (View view : this.childViews) {
                int position = this.lm.getPosition(view);
                if (!this.isInside(view)) continue;
                if (this.lm.getDecoratedTop(view) < this.lm.getDecoratedTop(this.topView)) {
                    this.topView = view;
                }
                if (this.lm.getDecoratedBottom(view) > this.lm.getDecoratedBottom(this.bottomView)) {
                    this.bottomView = view;
                }
                if (this.lm.getDecoratedLeft(view) < this.lm.getDecoratedLeft(this.leftView)) {
                    this.leftView = view;
                }
                if (this.lm.getDecoratedRight(view) > this.lm.getDecoratedRight(this.rightView)) {
                    this.rightView = view;
                }
                if (this.minPositionOnScreen == -1 || position < this.minPositionOnScreen) {
                    this.minPositionOnScreen = position;
                }
                if (this.maxPositionOnScreen == -1 || position > this.maxPositionOnScreen) {
                    this.maxPositionOnScreen = position;
                }
                if (position != 0) continue;
                this.isFirstItemAdded = true;
            }
        }
    }

    @Override
    public View getTopView() {
        return this.topView;
    }

    @Override
    public View getBottomView() {
        return this.bottomView;
    }

    @Override
    public View getLeftView() {
        return this.leftView;
    }

    @Override
    public View getRightView() {
        return this.rightView;
    }

    @Override
    public Integer getMinPositionOnScreen() {
        return this.minPositionOnScreen;
    }

    @Override
    public Integer getMaxPositionOnScreen() {
        return this.maxPositionOnScreen;
    }

    @Override
    public boolean isFirstItemAdded() {
        return this.isFirstItemAdded;
    }
}

