/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import blade.exception.BladeException;
import blade.kit.ReflectKit;
import blade.kit.StringKit;
import blade.kit.base.ThrowableKit;
import blade.kit.log.Logger;
import com.blade.Blade;
import com.blade.context.BladeWebContext;
import com.blade.http.Path;
import com.blade.http.Request;
import com.blade.http.Response;
import com.blade.render.ModelAndView;
import com.blade.route.Route;
import com.blade.route.RouteHandler;
import com.blade.route.RouteMatcher;
import com.blade.route.Router;
import com.blade.servlet.ServletRequest;
import com.blade.servlet.ServletResponse;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionHandler {
    private static final Logger LOGGER = Logger.getLogger(ActionHandler.class);
    private Blade blade;
    private Router router;
    private RouteMatcher routeMatcher;
    private static final String INTERNAL_ERROR = "<html><head><title>500 Internal Error</title></head><body bgcolor=\"white\"><center><h1>500 Internal Error</h1></center><hr><center>blade 1.4.1</center></body></html>";
    private static final String VIEW_NOTFOUND = "<html><head><title>404 Not Found</title></head><body bgcolor=\"white\"><center><h1>[ %s ] Not Found</h1></center><hr><center>blade 1.4.1</center></body></html>";
    private ServletContext context;

    public ActionHandler(ServletContext context, Blade blade) {
        this.blade = blade;
        this.router = blade.router();
        this.context = context;
        this.routeMatcher = new RouteMatcher(this.router);
    }

    public boolean handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        block7: {
            Response response = null;
            try {
                String method = httpRequest.getMethod();
                String uri = Path.getRelativePath(httpRequest);
                if (null != this.blade.staticFolder() && this.blade.staticFolder().length > 0 && !this.filterStaticFolder(uri)) {
                    return false;
                }
                if (this.blade.debug()) {
                    LOGGER.debug((Object)("Request : " + method + "\t" + uri));
                }
                ServletRequest request = new ServletRequest(httpRequest);
                response = new ServletResponse(httpResponse, this.blade.render());
                BladeWebContext.setContext(this.context, request, response);
                Route route = this.routeMatcher.getRoute(method, uri);
                if (route != null) {
                    List<Route> befores = this.routeMatcher.getBefore(uri);
                    this.invokeInterceptor(request, response, befores);
                    this.handle(request, response, route);
                    List<Route> afters = this.routeMatcher.getAfter(uri);
                    this.invokeInterceptor(request, response, afters);
                    return true;
                }
                this.render404(response, uri);
                return true;
            }
            catch (BladeException bex) {
                String error = ThrowableKit.getStackTraceAsString((Throwable)bex);
                LOGGER.error((Object)error);
                ThrowableKit.propagate((Throwable)bex);
                httpResponse.setStatus(500);
                if (!httpResponse.isCommitted()) {
                    response.html(INTERNAL_ERROR);
                    return true;
                }
            }
            catch (Exception e) {
                String error = ThrowableKit.getStackTraceAsString((Throwable)e);
                LOGGER.error((Object)error);
                ThrowableKit.propagate((Throwable)e);
                httpResponse.setStatus(500);
                if (httpResponse.isCommitted()) break block7;
                response.html(INTERNAL_ERROR);
                return true;
            }
        }
        return false;
    }

    private void render404(Response response, String uri) {
        String view404 = this.blade.view404();
        if (StringKit.isNotBlank((String)view404)) {
            ModelAndView modelAndView = new ModelAndView(view404);
            modelAndView.add("viewName", uri);
            response.render(modelAndView);
        } else {
            response.status(404);
            response.html(String.format(VIEW_NOTFOUND, uri));
        }
    }

    private void invokeInterceptor(Request request, Response response, List<Route> interceptors) {
        for (Route route : interceptors) {
            this.handle(request, response, route);
        }
    }

    private void handle(Request request, Response response, Route route) {
        Object target = route.getTarget();
        request.initPathParams(route.getPath());
        BladeWebContext.setContext(this.context, request, response);
        if (target instanceof RouteHandler) {
            RouteHandler routeHandler = (RouteHandler)target;
            routeHandler.handle(request, response);
        } else {
            Method actionMethod = route.getAction();
            this.executeMethod(target, actionMethod, request, response);
        }
    }

    private Object[] getArgs(Request request, Response response, Class<?>[] params) {
        int len = params.length;
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            Class<?> paramTypeClazz = params[i];
            if (paramTypeClazz.getName().equals(Request.class.getName())) {
                args[i] = request;
            }
            if (!paramTypeClazz.getName().equals(Response.class.getName())) continue;
            args[i] = response;
        }
        return args;
    }

    private Object executeMethod(Object object, Method method, Request request, Response response) {
        int len = method.getParameterTypes().length;
        method.setAccessible(true);
        if (len > 0) {
            Object[] args = this.getArgs(request, response, method.getParameterTypes());
            return ReflectKit.invokeMehod((Object)object, (Method)method, (Object[])args);
        }
        return ReflectKit.invokeMehod((Object)object, (Method)method, (Object[])new Object[0]);
    }

    private boolean filterStaticFolder(String uri) {
        int len = this.blade.staticFolder().length;
        for (int i = 0; i < len; ++i) {
            if (!uri.startsWith(this.blade.staticFolder()[i])) continue;
            return false;
        }
        return true;
    }
}

