/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import blade.kit.IOKit;
import blade.kit.PropertyKit;
import blade.kit.ReflectKit;
import blade.kit.json.JSONKit;
import com.blade.Bootstrap;
import com.blade.IocApplication;
import com.blade.http.HttpMethod;
import com.blade.ioc.Container;
import com.blade.ioc.SampleContainer;
import com.blade.loader.ClassPathRouteLoader;
import com.blade.loader.Config;
import com.blade.loader.Configurator;
import com.blade.plugin.Plugin;
import com.blade.render.JspRender;
import com.blade.render.Render;
import com.blade.route.Route;
import com.blade.route.RouteException;
import com.blade.route.RouteHandler;
import com.blade.route.Router;
import com.blade.server.Server;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

public class Blade {
    public static final String VERSION = "1.4.1";
    boolean isInit = false;
    private Bootstrap bootstrap = new Bootstrap(){

        @Override
        public void init() {
        }
    };
    private Config config = new Config();
    private Container container = SampleContainer.single();
    private Render render = new JspRender();
    private Router router = new Router();
    private static final int DEFAULT_PORT = 9000;
    private int port = 9000;
    private Server bladeServer;

    private Blade() {
    }

    public static Blade me() {
        return BladeHolder.ME;
    }

    public void setInit(boolean isInit) {
        this.isInit = isInit;
    }

    public Server createServer(int port) {
        return new Server(port);
    }

    public Router router() {
        return this.router;
    }

    public void regObject(Object object) {
        this.container.registBean(object);
    }

    public Blade config(String confName) {
        Map configMap = PropertyKit.getPropertyMap((String)confName);
        this.configuration(configMap);
        return this;
    }

    public Blade setAppConf(String confName) {
        Map configMap = PropertyKit.getPropertyMap((String)confName);
        this.configuration(configMap);
        return this;
    }

    public Blade setJsonConf(String jsonPath) {
        InputStream inputStream = Blade.class.getResourceAsStream(jsonPath);
        if (null != inputStream) {
            try {
                String json = IOKit.toString((InputStream)inputStream);
                Map configMap = JSONKit.toMap((String)json);
                this.configuration(configMap);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public Blade setAppJson(String json) {
        Map configMap = JSONKit.toMap((String)json);
        this.configuration(configMap);
        return this;
    }

    private void configuration(Map<String, String> configMap) {
        new Configurator(this.config, configMap).run();
    }

    public Blade routes(String ... packages) {
        if (null != packages && packages.length > 0) {
            this.config.setRoutePackages(packages);
        }
        return this;
    }

    public Blade defaultRoute(String basePackage) {
        if (null != basePackage) {
            this.config.setBasePackage(basePackage);
        }
        return this;
    }

    public Blade interceptor(String packageName) {
        if (null != packageName && packageName.length() > 0) {
            this.config.setInterceptorPackage(packageName);
        }
        return this;
    }

    public Blade ioc(String ... packages) {
        if (null != packages && packages.length > 0) {
            this.config.setIocPackages(packages);
        }
        return this;
    }

    public Blade route(String path, Object target, String method) {
        this.router.route(path, target, method);
        return this;
    }

    @Deprecated
    public Blade addRoute(String path, Object target, String method) {
        return this.route(path, target, method);
    }

    @Deprecated
    public Blade addRoute(String path, Object target, String method, HttpMethod httpMethod) {
        return this.route(path, target, method, httpMethod);
    }

    public Blade route(String path, Object target, String method, HttpMethod httpMethod) {
        this.router.route(path, target, method, httpMethod);
        return this;
    }

    public Blade route(String path, Class<?> clazz, String method) {
        this.router.route(path, clazz, method);
        return this;
    }

    public Blade route(String path, Class<?> clazz, String method, HttpMethod httpMethod) {
        this.router.route(path, clazz, method, httpMethod);
        return this;
    }

    public Blade get(String path, RouteHandler handler) {
        this.router.route(path, handler, HttpMethod.GET);
        return this;
    }

    public Blade post(String path, RouteHandler handler) {
        this.router.route(path, handler, HttpMethod.POST);
        return this;
    }

    public Blade delete(String path, RouteHandler handler) {
        this.router.route(path, handler, HttpMethod.DELETE);
        return this;
    }

    public Blade put(String path, RouteHandler handler) {
        this.router.route(path, handler, HttpMethod.PUT);
        return this;
    }

    public Blade all(String path, RouteHandler handler) {
        this.router.route(path, handler, HttpMethod.ALL);
        return this;
    }

    public Blade any(String path, RouteHandler handler) {
        this.router.route(path, handler, HttpMethod.ALL);
        return this;
    }

    public Blade before(String path, RouteHandler handler) {
        this.router.route(path, handler, HttpMethod.BEFORE);
        return this;
    }

    public Blade after(String path, RouteHandler handler) {
        this.router.route(path, handler, HttpMethod.AFTER);
        return this;
    }

    public Blade viewEngin(Render render) {
        this.render = render;
        return this;
    }

    public Blade viewPrefix(String prefix) {
        if (null != prefix && prefix.startsWith("/")) {
            this.config.setViewPrefix(prefix);
        }
        return this;
    }

    public Blade viewSuffix(String suffix) {
        if (null != suffix && suffix.startsWith(".")) {
            this.config.setViewSuffix(suffix);
        }
        return this;
    }

    public Blade view(String viewPath, String viewExt) {
        this.viewPrefix(viewPath);
        this.viewSuffix(viewExt);
        return this;
    }

    public Blade staticFolder(String ... folders) {
        this.config.setStaticFolders(folders);
        return this;
    }

    public Blade enableXSS(boolean enableXSS) {
        this.config.setEnableXSS(enableXSS);
        return this;
    }

    public Blade app(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public Blade app(Class<? extends Bootstrap> bootstrap) {
        this.bootstrap = (Bootstrap)ReflectKit.newInstance(bootstrap);
        return this;
    }

    public Blade setView404(String view404) {
        this.config.setView404(view404);
        return this;
    }

    public Blade setView500(String view500) {
        this.config.setView500(view500);
        return this;
    }

    public Blade webRoot(String webRoot) {
        this.config.setWebRoot(webRoot);
        return this;
    }

    public Blade debug(boolean isdebug) {
        this.config.setDebug(isdebug);
        return this;
    }

    public Blade listen(int port) {
        this.port = port;
        return this;
    }

    public void start(String contextPath) {
        try {
            this.bladeServer = new Server(this.port);
            this.bladeServer.start(contextPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        this.start("/");
    }

    public void stop() {
        try {
            this.bladeServer.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void join() throws InterruptedException {
        this.bladeServer.join();
    }

    public Config config() {
        return this.config;
    }

    public String basePackage() {
        return this.config.getBasePackage();
    }

    public String[] routePackages() {
        return this.config.getRoutePackages();
    }

    public String[] iocs() {
        return this.config.getIocPackages();
    }

    public String interceptorPackage() {
        return this.config.getInterceptorPackage();
    }

    public String viewPrefix() {
        return this.config.getViewPrefix();
    }

    public String encoding() {
        return this.config.getEncoding();
    }

    public String viewSuffix() {
        return this.config.getViewSuffix();
    }

    public String view404() {
        return this.config.getView404();
    }

    public String view500() {
        return this.config.getView500();
    }

    public String webRoot() {
        return this.config.getWebRoot();
    }

    public boolean debug() {
        return this.config.isDebug();
    }

    public String[] staticFolder() {
        return this.config.getStaticFolders();
    }

    public Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public Render render() {
        return this.render;
    }

    public boolean enableXSS() {
        return this.config.isEnableXSS();
    }

    public <T> T plugin(Class<? extends Plugin> pluginClazz) {
        Plugin object = IocApplication.getPlugin(pluginClazz);
        if (null == object) {
            object = IocApplication.registerPlugin(pluginClazz);
        }
        return (T)object;
    }

    public Blade routeConf(String basePackage, String conf) {
        try {
            InputStream ins = Blade.class.getResourceAsStream("/" + conf);
            ClassPathRouteLoader routesLoader = new ClassPathRouteLoader(ins);
            routesLoader.setBasePackage(basePackage);
            List<Route> routes = routesLoader.load();
            this.router.addRoutes(routes);
        }
        catch (RouteException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this;
    }

    private static class BladeHolder {
        private static Blade ME = new Blade();

        private BladeHolder() {
        }
    }
}

