/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import blade.kit.StringKit;
import blade.kit.TaskKit;
import blade.kit.log.Logger;
import com.blade.ActionHandler;
import com.blade.Blade;
import com.blade.Bootstrap;
import com.blade.IocApplication;
import com.blade.context.BladeWebContext;
import com.blade.route.RouteBuilder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CoreFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(CoreFilter.class);
    private static final String BOOSTRAP_CLASS = "bootstrapClass";
    private Blade blade;
    private ActionHandler actionHandler;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.blade = Blade.me();
            if (!this.blade.isInit) {
                this.blade.webRoot(filterConfig.getServletContext().getRealPath("/"));
                Bootstrap bootstrap = this.blade.bootstrap();
                String bootStrapClassName = filterConfig.getInitParameter(BOOSTRAP_CLASS);
                if (StringKit.isNotBlank((String)bootStrapClassName)) {
                    bootstrap = this.getBootstrap(filterConfig.getInitParameter(BOOSTRAP_CLASS));
                    bootstrap.init();
                    this.blade.app(bootstrap);
                }
                new RouteBuilder(this.blade).building();
                IocApplication.init(this.blade);
                bootstrap.contextInitialized(this.blade);
                this.blade.setInit(true);
                this.actionHandler = new ActionHandler(filterConfig.getServletContext(), this.blade);
                LOGGER.info((Object)"blade init complete!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private Bootstrap getBootstrap(String botstrapClassName) throws ServletException {
        Bootstrap bootstrapClass;
        block4: {
            bootstrapClass = null;
            try {
                if (null != botstrapClassName) {
                    Class<?> applicationClass = Class.forName(botstrapClassName);
                    if (null != applicationClass) {
                        bootstrapClass = (Bootstrap)applicationClass.newInstance();
                    }
                    break block4;
                }
                throw new ServletException("bootstrapClass is null !");
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        return bootstrapClass;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpRequest.setCharacterEncoding(this.blade.encoding());
        httpResponse.setCharacterEncoding(this.blade.encoding());
        boolean isHandler = this.actionHandler.handle(httpRequest, httpResponse);
        if (!isHandler) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    public void destroy() {
        LOGGER.info((Object)"blade destroy!");
        BladeWebContext.remove();
        IocApplication.destroy();
        TaskKit.depose();
    }
}

