/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import blade.kit.CollectionKit;
import blade.kit.log.Logger;
import blade.kit.resource.ClassPathClassReader;
import blade.kit.resource.ClassReader;
import com.blade.Blade;
import com.blade.Bootstrap;
import com.blade.ioc.Container;
import com.blade.ioc.SampleContainer;
import com.blade.ioc.Scope;
import com.blade.plugin.Plugin;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class IocApplication {
    private static final Logger LOGGER = Logger.getLogger(IocApplication.class);
    private static final Container container = SampleContainer.single();
    private static final ClassReader classReader = new ClassPathClassReader();
    private static final List<Plugin> PLUGINS = CollectionKit.newArrayList();

    public static void init(Blade blade) {
        if (null == container.getBean(Bootstrap.class, Scope.SINGLE)) {
            container.registBean(blade.bootstrap());
        }
        IocApplication.initIOC(blade.iocs());
        container.initWired();
        Collection beans = container.getBeans();
        for (Object object : beans) {
            LOGGER.info((Object)("Add Object\uff1a" + object.getClass() + "=" + object));
        }
    }

    private static void initIOC(String[] iocPackages) {
        if (null != iocPackages && iocPackages.length > 0) {
            for (String packageName : iocPackages) {
                IocApplication.registerBean(packageName);
            }
        }
    }

    public static <T extends Plugin> T registerPlugin(Class<T> pluginClazz) {
        Object object = container.registBean(pluginClazz);
        Plugin plugin = (Plugin)object;
        PLUGINS.add(plugin);
        return (T)plugin;
    }

    public static <T extends Plugin> T getPlugin(Class<T> pluginClazz) {
        return (T)((Plugin)container.getBean(pluginClazz, Scope.SINGLE));
    }

    private static void registerBean(String packageName) {
        boolean recursive = false;
        if (packageName.endsWith(".*")) {
            packageName = packageName.substring(0, packageName.length() - 2);
            recursive = true;
        }
        Set classes = classReader.getClass(packageName, recursive);
        for (Class clazz : classes) {
            if (!container.isRegister(clazz.getAnnotations())) continue;
            container.registBean(clazz);
        }
    }

    public static void destroy() {
        container.removeAll();
        for (Plugin plugin : PLUGINS) {
            plugin.destroy();
        }
    }
}

