/*
 * Decompiled with CFR 0.152.
 */
package com.blade.context;

import com.blade.http.Request;
import com.blade.http.Response;
import com.blade.servlet.Session;
import javax.servlet.ServletContext;

public final class BladeWebContext {
    private static final ThreadLocal<BladeWebContext> BLADE_WEB_CONTEXT = new ThreadLocal();
    private ServletContext context;
    private Request request;
    private Response response;

    private BladeWebContext() {
    }

    public static BladeWebContext me() {
        return BLADE_WEB_CONTEXT.get();
    }

    public static void setContext(ServletContext context, Request request, Response response) {
        BladeWebContext bladeWebContext = new BladeWebContext();
        bladeWebContext.context = context;
        bladeWebContext.request = request;
        bladeWebContext.response = response;
        BLADE_WEB_CONTEXT.set(bladeWebContext);
    }

    public static void remove() {
        BLADE_WEB_CONTEXT.remove();
    }

    public static Request request() {
        return BladeWebContext.me().request;
    }

    public static Response response() {
        return BladeWebContext.me().response;
    }

    public static Session session() {
        return BladeWebContext.request().session();
    }

    public static ServletContext servletContext() {
        return BladeWebContext.me().context;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }
}

