/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc;

import blade.exception.BladeException;
import blade.kit.CloneKit;
import blade.kit.CollectionKit;
import blade.kit.ReflectKit;
import blade.kit.log.Logger;
import com.blade.annotation.Component;
import com.blade.annotation.Inject;
import com.blade.annotation.Path;
import com.blade.ioc.Container;
import com.blade.ioc.Scope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleContainer
implements Container {
    private static final Logger LOGGER = Logger.getLogger(SampleContainer.class);
    private static final Map<String, Object> BEAN_CONTAINER = CollectionKit.newConcurrentHashMap();
    private static final Map<Class<? extends Annotation>, List<Object>> ANNOTATION_CONTAINER = CollectionKit.newConcurrentHashMap();

    private SampleContainer() {
    }

    public static SampleContainer single() {
        return DefaultContainerHoder.single;
    }

    @Override
    public Map<String, Object> getBeanMap() {
        return BEAN_CONTAINER;
    }

    @Override
    public <T> T getBean(String name, Scope scope) {
        Object obj = BEAN_CONTAINER.get(name);
        if (null != scope && scope == Scope.PROTOTYPE) {
            try {
                return (T)CloneKit.deepClone((Object)obj);
            }
            catch (Exception e) {
                LOGGER.error((Object)("\u514b\u9686\u5bf9\u8c61\u5931\u8d25," + e.getMessage()));
            }
        }
        return (T)obj;
    }

    @Override
    public <T> T getBean(Class<T> type, Scope scope) {
        Set<String> keys = BEAN_CONTAINER.keySet();
        for (String key : keys) {
            Object obj = BEAN_CONTAINER.get(key);
            if (!type.isAssignableFrom(obj.getClass())) continue;
            if (null != scope && scope == Scope.PROTOTYPE) {
                try {
                    return (T)CloneKit.deepClone((Object)obj);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("\u514b\u9686\u5bf9\u8c61\u5931\u8d25," + e.getMessage()));
                    continue;
                }
            }
            return (T)obj;
        }
        return null;
    }

    @Override
    public Set<String> getBeanNames() {
        return BEAN_CONTAINER.keySet();
    }

    public Collection<Object> getBeans() {
        return BEAN_CONTAINER.values();
    }

    @Override
    public boolean hasBean(Class<?> clz) {
        return null != SampleContainer.single().getBean(clz, Scope.SINGLE);
    }

    @Override
    public boolean hasBean(String name) {
        return null != SampleContainer.single().getBean(name, Scope.SINGLE);
    }

    @Override
    public boolean removeBean(String name) {
        Object object = BEAN_CONTAINER.remove(name);
        return null != object;
    }

    @Override
    public boolean removeBean(Class<?> clazz) {
        Object object = BEAN_CONTAINER.remove(clazz.getName());
        return null != object;
    }

    @Override
    public Object registBean(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        Object object = null;
        if (!Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface()) {
            object = ReflectKit.newInstance(clazz);
            this.put(name, object);
            if (clazz.getInterfaces().length > 0) {
                this.put(clazz.getInterfaces()[0].getCanonicalName(), object);
            }
            if (null != clazz.getDeclaredAnnotations()) {
                this.putAnnotationMap(clazz, object);
            }
        }
        return object;
    }

    private void put(String name, Object object) {
        if (!BEAN_CONTAINER.containsValue(object)) {
            BEAN_CONTAINER.put(name, object);
        }
    }

    private void putAnnotationMap(Class<?> clazz, Object object) {
        Annotation[] annotations = clazz.getAnnotations();
        ArrayList listObject = null;
        for (Annotation annotation : annotations) {
            if (null == annotation) continue;
            listObject = ANNOTATION_CONTAINER.get(annotation.annotationType());
            if (CollectionKit.isEmpty(listObject)) {
                listObject = CollectionKit.newArrayList();
            }
            listObject.add(object);
            SampleContainer.single().put(annotation.annotationType(), listObject);
        }
    }

    private void put(Class<? extends Annotation> clazz, List<Object> listObject) {
        if (null == ANNOTATION_CONTAINER.get(clazz)) {
            ANNOTATION_CONTAINER.put(clazz, listObject);
        }
    }

    @Override
    public void initWired() throws RuntimeException {
        for (Map.Entry<String, Object> entry : BEAN_CONTAINER.entrySet()) {
            Object object = entry.getValue();
            this.injection(object);
        }
    }

    private Object recursiveAssembly(Class<?> clazz) {
        Object field = null;
        if (null != clazz) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                String implClassName = clazz.getPackage().getName() + ".impl." + clazz.getSimpleName() + "Impl";
                return ReflectKit.newInstance((String)implClassName);
            }
            field = SampleContainer.single().registBean(clazz);
        }
        return field;
    }

    @Override
    public boolean isRegister(Annotation[] annotations) {
        if (null == annotations || annotations.length == 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Component) && !(annotation instanceof Path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Class<?>> getClassesByAnnotation(Class<? extends Annotation> annotation) {
        List objectList = this.getBeansByAnnotation(annotation);
        if (!CollectionKit.isEmpty(objectList)) {
            ArrayList classList = CollectionKit.newArrayList((int)objectList.size());
            for (Object object : objectList) {
                classList.add(object.getClass());
            }
            return classList;
        }
        return null;
    }

    @Override
    public <T> List<T> getBeansByAnnotation(Class<? extends Annotation> annotation) {
        return ANNOTATION_CONTAINER.get(annotation);
    }

    @Override
    public void registBean(Set<Class<?>> classes) {
        if (!CollectionKit.isEmpty(classes)) {
            for (Class<?> clazz : classes) {
                SampleContainer.single().registBean(clazz);
            }
        }
    }

    @Override
    public Object registBean(Object object) {
        String name = object.getClass().getName();
        this.put(name, object);
        return object;
    }

    @Override
    public boolean removeAll() {
        BEAN_CONTAINER.clear();
        ANNOTATION_CONTAINER.clear();
        return true;
    }

    @Override
    public void injection(Object object) {
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                Inject inject = field.getAnnotation(Inject.class);
                if (null == inject) continue;
                Object injectField = SampleContainer.single().getBean(field.getType(), Scope.SINGLE);
                if (inject.value() != Class.class) {
                    injectField = SampleContainer.single().getBean(inject.value(), Scope.SINGLE);
                    if (null == injectField) {
                        injectField = this.recursiveAssembly(inject.value());
                    }
                } else if (null == injectField) {
                    injectField = this.recursiveAssembly(field.getType());
                }
                if (null == injectField) {
                    throw new BladeException("Unable to load " + field.getType().getCanonicalName() + "\uff01");
                }
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                field.set(object, injectField);
                field.setAccessible(accessible);
            }
        }
        catch (SecurityException e) {
            LOGGER.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e);
        }
    }

    private static class DefaultContainerHoder {
        private static final SampleContainer single = new SampleContainer();

        private DefaultContainerHoder() {
        }
    }
}

