/*
 * Decompiled with CFR 0.152.
 */
package com.blade.loader;

import com.blade.ioc.Container;
import com.blade.ioc.SampleContainer;
import com.blade.ioc.Scope;
import com.blade.loader.ControllerLoader;
import com.blade.route.RouteException;

public class ClassPathControllerLoader
implements ControllerLoader {
    private String basePackage;
    private ClassLoader classLoader = ClassPathControllerLoader.class.getClassLoader();
    private Container container = SampleContainer.single();

    public ClassPathControllerLoader() {
        this("");
    }

    public ClassPathControllerLoader(String basePackage) {
        this.basePackage = basePackage;
        if (this.basePackage != null && !"".equals(this.basePackage) && !this.basePackage.endsWith(".")) {
            this.basePackage = this.basePackage + ".";
        }
    }

    @Override
    public Object load(String controllerName) throws RouteException {
        String className = this.basePackage + controllerName;
        try {
            Class<?> controllerClass = this.classLoader.loadClass(className);
            Object controller = this.container.getBean(controllerClass, Scope.SINGLE);
            if (null == controller) {
                controller = controllerClass.newInstance();
                this.container.registBean(controller);
            }
            return controller;
        }
        catch (Exception e) {
            throw new RouteException(e);
        }
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

