/*
 * Decompiled with CFR 0.152.
 */
package com.blade.loader;

import blade.kit.CollectionKit;
import blade.kit.PatternKit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Config {
    private Map<String, String> configMap = CollectionKit.newHashMap();
    private List<String> routePackages = CollectionKit.newArrayList();
    private List<String> iocPackages = CollectionKit.newArrayList();
    private List<String> staticFolders = CollectionKit.newArrayList();
    private String basePackage;
    private String interceptorPackage;
    private String encoding = "utf-8";
    private String viewPrefix = "/WEB-INF/";
    private String viewSuffix = ".jsp";
    private String webRoot;
    private String view404;
    private String view500;
    private boolean isDebug = true;
    private boolean enableXSS = false;

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, String> configMap) {
        this.configMap = configMap;
    }

    public String get(String key) {
        return this.configMap.get(key);
    }

    public Integer getToInt(String key) {
        String val = this.get(key);
        if (null != val && PatternKit.isNumber((String)val)) {
            return Integer.valueOf(val);
        }
        return null;
    }

    public Long getToLong(String key) {
        String val = this.get(key);
        if (null != val && PatternKit.isNumber((String)val)) {
            return Long.valueOf(val);
        }
        return null;
    }

    public Boolean getToBoolean(String key) {
        String val = this.get(key);
        if (null != val) {
            return Boolean.valueOf(val);
        }
        return null;
    }

    public Double getToDouble(String key) {
        String val = this.get(key);
        if (null != val) {
            return Double.valueOf(val);
        }
        return null;
    }

    public Float getToFloat(String key) {
        String val = this.get(key);
        if (null != val) {
            return Float.valueOf(val);
        }
        return null;
    }

    public String[] getRoutePackages() {
        String[] routeArr = new String[this.routePackages.size()];
        return this.routePackages.toArray(routeArr);
    }

    public void setRoutePackages(String ... packages) {
        this.routePackages.addAll(Arrays.asList(packages));
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String[] getIocPackages() {
        String[] iocArr = new String[this.iocPackages.size()];
        return this.iocPackages.toArray(iocArr);
    }

    public void setIocPackages(String ... packages) {
        this.iocPackages.addAll(Arrays.asList(packages));
    }

    public String getInterceptorPackage() {
        return this.interceptorPackage;
    }

    public void setInterceptorPackage(String interceptorPackage) {
        this.interceptorPackage = interceptorPackage;
    }

    public String getViewPrefix() {
        return this.viewPrefix;
    }

    public void setViewPrefix(String viewPrefix) {
        this.viewPrefix = viewPrefix;
    }

    public String getViewSuffix() {
        return this.viewSuffix;
    }

    public void setViewSuffix(String viewSuffix) {
        this.viewSuffix = viewSuffix;
    }

    public String[] getStaticFolders() {
        String[] folderArr = new String[this.staticFolders.size()];
        return this.staticFolders.toArray(folderArr);
    }

    public void setStaticFolders(String ... packages) {
        this.staticFolders.addAll(Arrays.asList(packages));
    }

    public String getView404() {
        return this.view404;
    }

    public void setView404(String view404) {
        this.view404 = view404;
    }

    public String getView500() {
        return this.view500;
    }

    public void setView500(String view500) {
        this.view500 = view500;
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isEnableXSS() {
        return this.enableXSS;
    }

    public void setEnableXSS(boolean enableXSS) {
        this.enableXSS = enableXSS;
    }
}

