/*
 * Decompiled with CFR 0.152.
 */
package com.blade.loader;

import blade.kit.StringKit;
import com.blade.loader.Config;
import java.util.Map;

public class Configurator {
    private Config bladeConfig;
    private Map<String, String> configMap;
    private static final String BLADE_ROUTE = "blade.route";
    private static final String BLADE_INTERCEPTOR = "blade.interceptor";
    private static final String BLADE_IOC = "blade.ioc";
    private static final String BLADE_PREFIX = "blade.prefix";
    private static final String BLADE_SUFFIX = "blade.suffix";
    private static final String BLADE_FILTER_FOLDER = "blade.filter_folder";
    private static final String BLADE_ENCODING = "blade.encoding";
    private static final String BLADE_VIEW_404 = "blade.view404";
    private static final String BLADE_VIEW_500 = "blade.view500";
    private static final String BLADE_DEBUG = "blade.debug";
    private static final String BLADE_ENABLEXSS = "blade.enableXSS";

    public Configurator(Config bladeConfig, Map<String, String> configMap) {
        this.bladeConfig = bladeConfig;
        this.configMap = configMap;
    }

    public void run() {
        if (null != this.configMap && this.configMap.size() > 0) {
            this.bladeConfig.setConfigMap(this.configMap);
            String route = this.configMap.get(BLADE_ROUTE);
            String interceptor = this.configMap.get(BLADE_INTERCEPTOR);
            String ioc = this.configMap.get(BLADE_IOC);
            String prefix = this.configMap.get(BLADE_PREFIX);
            String suffix = this.configMap.get(BLADE_SUFFIX);
            String filter_folder = this.configMap.get(BLADE_FILTER_FOLDER);
            String encoding = this.configMap.get(BLADE_ENCODING);
            String view404 = this.configMap.get(BLADE_VIEW_404);
            String view500 = this.configMap.get(BLADE_VIEW_500);
            String debug = this.configMap.get(BLADE_DEBUG);
            String xss = this.configMap.get(BLADE_ENABLEXSS);
            if (StringKit.isNotBlank((String)route)) {
                String[] blade_routes = StringKit.split((String)route, (String)",");
                this.bladeConfig.setRoutePackages(blade_routes);
            }
            if (StringKit.isNotBlank((String)filter_folder)) {
                String[] blade_filter_folders = StringKit.split((String)filter_folder, (String)",");
                this.bladeConfig.setStaticFolders(blade_filter_folders);
            }
            if (StringKit.isNotBlank((String)interceptor)) {
                this.bladeConfig.setInterceptorPackage(interceptor);
            }
            if (StringKit.isNotBlank((String)ioc)) {
                String[] blade_iocs = StringKit.split((String)ioc, (String)",");
                this.bladeConfig.setIocPackages(blade_iocs);
            }
            if (StringKit.isNotBlank((String)prefix)) {
                this.bladeConfig.setViewPrefix(prefix);
            }
            if (StringKit.isNotBlank((String)suffix)) {
                this.bladeConfig.setViewSuffix(suffix);
            }
            if (StringKit.isNotBlank((String)encoding)) {
                this.bladeConfig.setEncoding(encoding);
            }
            if (StringKit.isNotBlank((String)view404)) {
                this.bladeConfig.setView404(view404);
            }
            if (StringKit.isNotBlank((String)view500)) {
                this.bladeConfig.setView500(view500);
            }
            if (StringKit.isNotBlank((String)debug)) {
                Boolean debugBool = Boolean.valueOf(debug);
                this.bladeConfig.setDebug(debugBool);
            }
            if (StringKit.isNotBlank((String)xss)) {
                Boolean enableXssBool = Boolean.valueOf(xss);
                this.bladeConfig.setEnableXSS(enableXssBool);
            }
        }
    }
}

