/*
 * Decompiled with CFR 0.152.
 */
package com.blade.render;

import blade.kit.log.Logger;
import com.blade.Blade;
import com.blade.context.BladeWebContext;
import com.blade.http.Request;
import com.blade.render.ModelAndView;
import com.blade.render.Render;
import com.blade.render.RenderException;
import com.blade.servlet.Session;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.resource.WebAppResourceLoader;

public class BeetlRender
implements Render {
    private static final Logger LOGGER = Logger.getLogger(BeetlRender.class);
    private GroupTemplate groupTemplate = null;
    private Blade blade;

    public BeetlRender() {
        try {
            this.blade = Blade.me();
            String root = this.blade.webRoot() + this.blade.viewPrefix();
            WebAppResourceLoader resourceLoader = new WebAppResourceLoader();
            resourceLoader.setAutoCheck(true);
            resourceLoader.setRoot(root);
            Configuration cfg = Configuration.defaultConfiguration();
            this.groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    public BeetlRender(GroupTemplate groupTemplate) {
        this.blade = Blade.me();
        this.groupTemplate = groupTemplate;
    }

    public BeetlRender(Configuration configuration) {
        try {
            this.blade = Blade.me();
            String root = this.blade.webRoot() + this.blade.viewPrefix();
            WebAppResourceLoader resourceLoader = new WebAppResourceLoader();
            resourceLoader.setAutoCheck(true);
            resourceLoader.setRoot(root);
            Configuration cfg = Configuration.defaultConfiguration();
            this.groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
            this.groupTemplate.setConf(configuration);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    @Override
    public void render(ModelAndView modelAndView, Writer writer) throws RenderException {
        Set<String> session_attrs;
        Set<String> attrs;
        Request request = BladeWebContext.request();
        Session session = request.session();
        Template template = this.groupTemplate.getTemplate(modelAndView.getView());
        Map<String, Object> context = modelAndView.getModel();
        if (null != context && context.size() > 0) {
            Set<String> keys = context.keySet();
            for (String string : keys) {
                template.binding(string, context.get(string));
            }
        }
        if (null != (attrs = request.attributes()) && attrs.size() > 0) {
            for (String string : attrs) {
                template.binding(string, request.attribute(string));
            }
        }
        if (null != (session_attrs = session.attributes()) && session_attrs.size() > 0) {
            for (String attr : session_attrs) {
                template.binding(attr, session.attribute(attr));
            }
        }
        try {
            template.renderTo(writer);
        }
        catch (BeetlException beetlException) {
            beetlException.printStackTrace();
            LOGGER.error((Object)beetlException);
        }
    }
}

