/*
 * Decompiled with CFR 0.152.
 */
package com.blade.render;

import blade.kit.log.Logger;
import com.blade.Blade;
import com.blade.context.BladeWebContext;
import com.blade.http.Request;
import com.blade.render.ModelAndView;
import com.blade.render.Render;
import com.blade.servlet.Session;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jetbrick.template.JetEngine;
import jetbrick.template.JetTemplate;

public class JetbrickRender
implements Render {
    private static final Logger LOGGER = Logger.getLogger(JetbrickRender.class);
    private JetEngine jetEngine;
    private Properties config;
    private Blade blade = Blade.me();

    public JetbrickRender() {
        this.config = new Properties();
        this.config.put("jetx.input.encoding", this.blade.encoding());
        this.config.put("jetx.output.encoding", this.blade.encoding());
        this.config.put("jetx.template.suffix", ".html");
        this.config.put("jetx.template.loaders", "jetbrick.template.loader.FileSystemResourceLoader");
        this.jetEngine = JetEngine.create((Properties)this.config);
    }

    public JetEngine getJetEngine() {
        return this.jetEngine;
    }

    public void clean() {
        if (null != this.config) {
            this.config.clear();
        }
    }

    public void put(String key, Object value) {
        if (null == this.config) {
            this.config = new Properties();
        }
        this.config.put(key, value);
    }

    public JetbrickRender(String configLocation) throws IOException {
        this.jetEngine = JetEngine.create((String)configLocation);
    }

    public JetbrickRender(Properties config) {
        this.config = config;
        this.jetEngine = JetEngine.create((Properties)this.config);
    }

    public JetbrickRender(JetEngine jetEngine) {
        this.jetEngine = jetEngine;
    }

    @Override
    public void render(ModelAndView modelAndView, Writer writer) {
        Set<String> session_attrs;
        Request request = BladeWebContext.request();
        Session session = request.session();
        JetTemplate template = this.jetEngine.getTemplate(modelAndView.getView());
        Map<String, Object> context = modelAndView.getModel();
        Set<String> attrs = request.attributes();
        if (null != attrs && attrs.size() > 0) {
            for (String string : attrs) {
                context.put(string, request.attribute(string));
            }
        }
        if (null != (session_attrs = session.attributes()) && session_attrs.size() > 0) {
            for (String attr : session_attrs) {
                context.put(attr, session.attribute(attr));
            }
        }
        try {
            template.render(context, writer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LOGGER.error((Object)exception);
        }
    }
}

