/*
 * Decompiled with CFR 0.152.
 */
package com.blade.render;

import blade.kit.log.Logger;
import com.blade.Blade;
import com.blade.context.BladeWebContext;
import com.blade.http.Request;
import com.blade.render.ModelAndView;
import com.blade.render.Render;
import com.blade.render.RenderException;
import com.blade.servlet.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityRender
implements Render {
    private static final Logger LOGGER = Logger.getLogger(VelocityRender.class);
    private final VelocityEngine velocityEngine;
    private Blade blade = Blade.me();

    public VelocityRender() {
        Properties properties = new Properties();
        properties.setProperty("file.resource.loader.path", this.blade.webRoot());
        properties.setProperty("ISO-8859-1", this.blade.encoding());
        properties.setProperty("input.encoding", this.blade.encoding());
        properties.setProperty("output.encoding", this.blade.encoding());
        this.velocityEngine = new VelocityEngine(properties);
    }

    public VelocityRender(String propertiesFile) throws IOException {
        String loadPath = VelocityRender.class.getClassLoader().getResource("/").getPath();
        String fileName = loadPath + propertiesFile;
        Properties properties = new Properties();
        FileInputStream inStream = new FileInputStream(new File(fileName));
        properties.load(inStream);
        if (!properties.contains("file.resource.loader.path")) {
            properties.put("file.resource.loader.path", this.blade.webRoot());
        }
        this.velocityEngine = new VelocityEngine(properties);
    }

    public VelocityRender(Properties properties) {
        this.velocityEngine = new VelocityEngine(properties);
    }

    public VelocityRender(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    @Override
    public void render(ModelAndView modelAndView, Writer writer) throws RenderException {
        Set<String> session_attrs;
        Request request = BladeWebContext.request();
        Session session = request.session();
        VelocityContext context = new VelocityContext(modelAndView.getModel());
        Set<String> attrs = request.attributes();
        if (null != attrs && attrs.size() > 0) {
            for (String string : attrs) {
                context.put(string, request.attribute(string));
            }
        }
        if (null != (session_attrs = session.attributes()) && session_attrs.size() > 0) {
            for (String attr : session_attrs) {
                context.put(attr, session.attribute(attr));
            }
        }
        try {
            Template template = this.velocityEngine.getTemplate(modelAndView.getView());
            template.merge((Context)context, writer);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LOGGER.error((Object)iOException);
        }
    }
}

