/*
 * Decompiled with CFR 0.152.
 */
package com.blade.route;

import blade.kit.StringKit;
import blade.kit.resource.ClassPathClassReader;
import blade.kit.resource.ClassReader;
import com.blade.Blade;
import com.blade.annotation.After;
import com.blade.annotation.Before;
import com.blade.annotation.Interceptor;
import com.blade.annotation.Path;
import com.blade.annotation.Route;
import com.blade.http.HttpMethod;
import com.blade.ioc.Container;
import com.blade.ioc.SampleContainer;
import com.blade.route.Router;
import java.lang.reflect.Method;
import java.util.Set;

public class RouteBuilder {
    private String PACKAGE_ROUTE = "route";
    private String PACKAGE_INTERCEPTOR = "interceptor";
    private ClassReader classReader = new ClassPathClassReader();
    private Container container = SampleContainer.single();
    private Blade blade;
    private Router router;

    public RouteBuilder(Blade blade) {
        this.blade = blade;
        this.router = blade.router();
    }

    public void building() {
        String basePackage = this.blade.basePackage();
        if (StringKit.isNotBlank((String)basePackage)) {
            String suffix = basePackage.endsWith(".*") ? ".*" : "";
            basePackage = basePackage.endsWith(".*") ? basePackage.substring(0, basePackage.length() - 2) : basePackage;
            String routePackage = basePackage + "." + this.PACKAGE_ROUTE + suffix;
            String interceptorPackage = basePackage + "." + this.PACKAGE_INTERCEPTOR + suffix;
            this.buildRoute(routePackage);
            this.buildInterceptor(interceptorPackage);
        } else {
            String interceptorPackage;
            String[] routePackages = this.blade.routePackages();
            if (null != routePackages && routePackages.length > 0) {
                this.buildRoute(routePackages);
            }
            if (StringKit.isNotBlank((String)(interceptorPackage = this.blade.interceptorPackage()))) {
                this.buildInterceptor(interceptorPackage);
            }
        }
    }

    private void buildInterceptor(String ... interceptorPackages) {
        Set classes = null;
        for (String packageName : interceptorPackages) {
            boolean recursive = false;
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 2);
                recursive = true;
            }
            if (null == (classes = this.classReader.getClassByAnnotation(packageName, Interceptor.class, recursive)) || classes.size() <= 0) continue;
            for (Class interceptorClazz : classes) {
                this.parseInterceptor(interceptorClazz);
            }
        }
    }

    private void buildRoute(String ... routePackages) {
        Set classes = null;
        for (String packageName : routePackages) {
            boolean recursive = false;
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 2);
                recursive = true;
            }
            if (null == (classes = this.classReader.getClassByAnnotation(packageName, Path.class, recursive)) || classes.size() <= 0) continue;
            for (Class pathClazz : classes) {
                this.parseRouter(pathClazz);
            }
        }
    }

    private void parseInterceptor(Class<?> interceptor) {
        Method[] methods = interceptor.getMethods();
        if (null == methods || methods.length == 0) {
            return;
        }
        this.container.registBean(interceptor);
        for (Method method : methods) {
            String pathV;
            String[] paths;
            String path;
            String suffix;
            Before before = method.getAnnotation(Before.class);
            After after = method.getAnnotation(After.class);
            if (null != before) {
                suffix = before.suffix();
                path = this.getRoutePath(before.value(), "", suffix);
                this.buildInterceptor(path, interceptor, method, HttpMethod.BEFORE);
                paths = before.values();
                if (null != paths && paths.length > 0) {
                    for (String value : paths) {
                        pathV = this.getRoutePath(value, "", suffix);
                        this.buildInterceptor(pathV, interceptor, method, HttpMethod.BEFORE);
                    }
                }
            }
            if (null == after) continue;
            suffix = after.suffix();
            path = this.getRoutePath(after.value(), "", suffix);
            this.buildInterceptor(path, interceptor, method, HttpMethod.AFTER);
            paths = after.values();
            if (null == paths || paths.length <= 0) continue;
            for (String value : paths) {
                pathV = this.getRoutePath(value, "", suffix);
                this.buildInterceptor(pathV, interceptor, method, HttpMethod.AFTER);
            }
        }
    }

    private void parseRouter(Class<?> router) {
        Method[] methods = router.getMethods();
        if (null == methods || methods.length == 0) {
            return;
        }
        this.container.registBean(router);
        String nameSpace = router.getAnnotation(Path.class).value();
        String suffix = router.getAnnotation(Path.class).suffix();
        for (Method method : methods) {
            Route mapping = method.getAnnotation(Route.class);
            if (null == mapping) continue;
            String path = this.getRoutePath(mapping.value(), nameSpace, suffix);
            HttpMethod methodType = mapping.method();
            this.buildRoute(router, method, path, methodType);
            String[] paths = mapping.values();
            if (null == paths || paths.length <= 0) continue;
            for (String value : paths) {
                String pathV = this.getRoutePath(value, nameSpace, suffix);
                this.buildRoute(router, method, pathV, methodType);
            }
        }
    }

    private String getRoutePath(String value, String nameSpace, String suffix) {
        String path = value.startsWith("/") ? value : "/" + value;
        path = nameSpace + path;
        path = path.replaceAll("[/]+", "/");
        path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        path = path + suffix;
        return path;
    }

    private void buildRoute(Class<?> clazz, Method execMethod, String path, HttpMethod method) {
        this.router.route(path, clazz, execMethod, method);
    }

    private void buildInterceptor(String path, Class<?> clazz, Method execMethod, HttpMethod method) {
        this.router.route(path, clazz, execMethod, method);
    }
}

