/*
 * Decompiled with CFR 0.152.
 */
package com.blade.route;

import com.blade.http.HttpMethod;
import com.blade.http.Path;
import com.blade.route.Route;
import com.blade.route.Router;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RouteMatcher {
    private List<Route> routes;
    private List<Route> interceptors;

    public RouteMatcher(Router router) {
        this.routes = router.getRoutes();
        this.interceptors = router.getInterceptors();
    }

    public Route getRoute(String httpMethod, String path) {
        String cleanPath = this.parsePath(path);
        ArrayList<Route> matchRoutes = new ArrayList<Route>();
        for (Route route : this.routes) {
            if (!this.matchesPath(route.getPath(), cleanPath) || route.getHttpMethod() != HttpMethod.ALL && HttpMethod.valueOf(httpMethod) != route.getHttpMethod()) continue;
            matchRoutes.add(route);
        }
        this.giveMatch(path, matchRoutes);
        return matchRoutes.size() > 0 ? (Route)matchRoutes.get(0) : null;
    }

    public List<Route> getBefore(String path) {
        ArrayList<Route> befores = new ArrayList<Route>();
        String cleanPath = this.parsePath(path);
        for (Route route : this.interceptors) {
            if (!this.matchesPath(route.getPath(), cleanPath) || route.getHttpMethod() != HttpMethod.BEFORE) continue;
            befores.add(route);
        }
        this.giveMatch(path, befores);
        return befores;
    }

    public List<Route> getAfter(String path) {
        ArrayList<Route> afters = new ArrayList<Route>();
        String cleanPath = this.parsePath(path);
        for (Route route : this.interceptors) {
            if (!this.matchesPath(route.getPath(), cleanPath) || route.getHttpMethod() != HttpMethod.AFTER) continue;
            afters.add(route);
        }
        this.giveMatch(path, afters);
        return afters;
    }

    private void giveMatch(final String uri, List<Route> routes) {
        Collections.sort(routes, new Comparator<Route>(){

            @Override
            public int compare(Route o1, Route o2) {
                if (o2.getPath().equals(uri)) {
                    return o2.getPath().indexOf(uri);
                }
                return -1;
            }
        });
    }

    private boolean matchesPath(String routePath, String pathToMatch) {
        routePath = routePath.replaceAll(":(\\w+)", "([^#/?]+)");
        return pathToMatch.matches("(?i)" + routePath);
    }

    private String parsePath(String path) {
        path = Path.fixPath(path);
        try {
            URI uri = new URI(path);
            return uri.getPath();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

