/*
 * Decompiled with CFR 0.152.
 */
package com.blade.route;

import blade.kit.ReflectKit;
import blade.kit.log.Logger;
import com.blade.http.HttpMethod;
import com.blade.http.Request;
import com.blade.http.Response;
import com.blade.ioc.Container;
import com.blade.ioc.SampleContainer;
import com.blade.ioc.Scope;
import com.blade.route.Route;
import com.blade.route.RouteHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Router {
    private Logger LOGGER = Logger.getLogger(Router.class);
    private static final Container container = SampleContainer.single();
    private List<Route> routes = new CopyOnWriteArrayList<Route>();
    private List<Route> interceptors = new CopyOnWriteArrayList<Route>();
    private static final String METHOD_NAME = "handle";

    public void handle(Request request, Response response, Route route) throws Exception {
        request.setRoute(route);
        response.status(404);
        Object controller = route.getTarget();
        Method method = route.getAction();
        try {
            method.invoke(controller, request, response);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getCause();
        }
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<Route> routes) {
        this.routes = routes;
    }

    public void addRoute(Route route) {
        this.routes.add(route);
    }

    public void addRoutes(List<Route> routes) {
        for (Route route : routes) {
            if (this.routes.contains(route)) {
                this.LOGGER.warn((Object)("\tRoute " + route + " has exist"));
                continue;
            }
            this.routes.add(route);
            this.LOGGER.debug((Object)("Add Route\uff1a" + route));
        }
    }

    public List<Route> getInterceptors() {
        return this.interceptors;
    }

    public void addInterceptors(List<Route> interceptors) {
        this.interceptors.addAll(interceptors);
    }

    public void addRoute(HttpMethod httpMethod, String path, Object controller, String methodName) throws NoSuchMethodException {
        Method method = controller.getClass().getMethod(methodName, Request.class, Response.class);
        this.addRoute(httpMethod, path, controller, method);
    }

    public void addRoute(HttpMethod httpMethod, String path, Object controller, Method method) {
        Route route = new Route(httpMethod, path, controller, method);
        if (this.routes.contains(route)) {
            this.LOGGER.warn((Object)("\tRoute " + route + " has exist"));
        }
        if (httpMethod == HttpMethod.BEFORE || httpMethod == HttpMethod.AFTER) {
            this.interceptors.add(route);
            this.LOGGER.debug((Object)("Add Interceptor\uff1a" + route));
        } else {
            this.routes.add(route);
            this.LOGGER.debug((Object)("Add Route\uff1a" + route));
        }
    }

    public void route(String path, RouteHandler handler, HttpMethod httpMethod) {
        try {
            this.addRoute(httpMethod, path, (Object)handler, METHOD_NAME);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void route(String[] paths, RouteHandler handler, HttpMethod httpMethod) {
        for (String path : paths) {
            this.route(path, handler, httpMethod);
        }
    }

    public void route(String path, Object target, String methodName) {
        try {
            Method method = target.getClass().getMethod(methodName, Request.class, Response.class);
            this.addRoute(HttpMethod.ALL, path, target, method);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void route(String path, Class<?> clazz, String methodName) {
        try {
            Object controller;
            HttpMethod httpMethod = HttpMethod.ALL;
            if (methodName.indexOf(":") != -1) {
                String[] methodArr = methodName.split(":");
                httpMethod = HttpMethod.valueOf(methodArr[0].toUpperCase());
                methodName = methodArr[1];
            }
            if (null == (controller = container.getBean(clazz, Scope.SINGLE))) {
                controller = ReflectKit.newInstance(clazz);
                container.registBean(controller);
            }
            Method method = clazz.getMethod(methodName, Request.class, Response.class);
            this.addRoute(httpMethod, path, controller, method);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void route(String path, Class<?> clazz, String methodName, HttpMethod httpMethod) {
        try {
            Object controller = container.getBean(clazz, Scope.SINGLE);
            if (null == controller) {
                controller = ReflectKit.newInstance(clazz);
                container.registBean(controller);
            }
            Method method = clazz.getMethod(methodName, Request.class, Response.class);
            this.addRoute(httpMethod, path, controller, method);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void route(String path, Class<?> clazz, Method method, HttpMethod httpMethod) {
        try {
            Object controller = container.getBean(clazz, Scope.SINGLE);
            if (null == controller) {
                controller = ReflectKit.newInstance(clazz);
                container.registBean(controller);
            }
            this.addRoute(httpMethod, path, controller, method);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void route(String path, Object target, String methodName, HttpMethod httpMethod) {
        try {
            Class<?> clazz = target.getClass();
            container.registBean(target);
            Method method = clazz.getMethod(methodName, Request.class, Response.class);
            this.addRoute(httpMethod, path, target, method);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

