/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server;

import blade.kit.log.Logger;
import com.blade.CoreFilter;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class Server {
    private static final Logger LOGGER = Logger.getLogger(Server.class);
    private int port = 9000;
    private org.eclipse.jetty.server.Server server;
    private ServletContextHandler context;

    public Server(int port) {
        this.port = port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start(String contextPath) throws Exception {
        this.server = new org.eclipse.jetty.server.Server(this.port);
        this.context = new ServletContextHandler(1);
        this.context.setContextPath(contextPath);
        this.context.setResourceBase(System.getProperty("java.io.tmpdir"));
        this.context.addFilter(CoreFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.server.setHandler((Handler)this.context);
        this.server.start();
        LOGGER.info((Object)("Blade Server Listen on 0.0.0.0:" + this.port));
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void stop() throws Exception {
        this.context.stop();
        this.server.stop();
    }
}

