/*
 * Decompiled with CFR 0.152.
 */
package com.blade.servlet;

import blade.kit.IOKit;
import blade.kit.text.HTMLFilter;
import com.blade.Blade;
import com.blade.http.HttpException;
import com.blade.http.HttpMethod;
import com.blade.http.Path;
import com.blade.http.Request;
import com.blade.route.Route;
import com.blade.servlet.Session;
import com.blade.servlet.multipart.FileItem;
import com.blade.servlet.multipart.Multipart;
import com.blade.servlet.multipart.MultipartException;
import com.blade.servlet.multipart.MultipartHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletRequest
implements Request {
    private static final String USER_AGENT = "user-agent";
    protected Route route;
    private HttpServletRequest request;
    protected Map<String, String> pathParams = new HashMap<String, String>();
    private Map<String, String> multipartParams = new HashMap<String, String>();
    private List<FileItem> files = new ArrayList<FileItem>();
    private Session session = null;
    private Blade blade = Blade.me();

    public ServletRequest(HttpServletRequest request) throws MultipartException, IOException {
        this.request = request;
        this.init();
    }

    public ServletRequest init() throws IOException, MultipartException {
        if (Multipart.isMultipartContent(this.request)) {
            Multipart multipart = new Multipart();
            multipart.parse(this.request, new MultipartHandler(){

                @Override
                public void handleFormItem(String name, String value) {
                    ServletRequest.this.multipartParams.put(name, value);
                }

                @Override
                public void handleFileItem(String name, FileItem fileItem) {
                    ServletRequest.this.files.add(fileItem);
                }
            });
        }
        return this;
    }

    private String join(String[] arr) {
        String ret = "";
        for (String item : arr) {
            ret = ret + "," + item;
        }
        if (ret.length() > 0) {
            ret = ret.substring(1);
        }
        return ret;
    }

    @Override
    public void initPathParams(String routePath) {
        this.pathParams.clear();
        List<String> variables = this.getPathParam(routePath);
        String regexPath = routePath.replaceAll(":(\\w+)", "([^#/?]+)");
        Matcher matcher = Pattern.compile("(?i)" + regexPath).matcher(this.path());
        matcher.matches();
        for (int i = 1; i <= variables.size(); ++i) {
            String value = matcher.group(i);
            this.pathParams.put(variables.get(i - 1), value);
        }
    }

    private List<String> getPathParam(String routePath) {
        ArrayList<String> variables = new ArrayList<String>();
        Matcher matcher = Pattern.compile(":(\\w+)").matcher(routePath);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }

    @Override
    public HttpServletRequest raw() {
        return this.request;
    }

    @Override
    public String host() {
        return this.request.getServerName();
    }

    @Override
    public String url() {
        return this.request.getRequestURL().toString();
    }

    @Override
    public String path() {
        return Path.fixPath(this.request.getRequestURI());
    }

    @Override
    public String userAgent() {
        return this.request.getHeader(USER_AGENT);
    }

    @Override
    public String pathInfo() {
        return this.request.getPathInfo();
    }

    @Override
    public String protocol() {
        return this.request.getProtocol();
    }

    @Override
    public String servletPath() {
        return this.request.getServletPath();
    }

    @Override
    public String contextPath() {
        return this.request.getContextPath();
    }

    @Override
    public ServletContext context() {
        return this.request.getServletContext();
    }

    @Override
    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    @Override
    public String param(String name) {
        String val = this.pathParams.get(name);
        if (this.blade.enableXSS()) {
            return HTMLFilter.htmlSpecialChars((String)val);
        }
        return val;
    }

    @Override
    public Integer paramAsInt(String name) {
        String value = this.param(name);
        if (null != value) {
            return Integer.valueOf(value);
        }
        return null;
    }

    @Override
    public Long paramAsLong(String name) {
        String value = this.param(name);
        if (null != value) {
            return Long.valueOf(value);
        }
        return null;
    }

    @Override
    public Boolean paramAsBoolean(String name) {
        String value = this.param(name);
        if (null != value) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    @Override
    public String queryString() {
        return this.request.getQueryString();
    }

    @Override
    public Map<String, String> querys() {
        HashMap params = new HashMap();
        Map requestParams = this.request.getParameterMap();
        for (Map.Entry entry : requestParams.entrySet()) {
            params.put(entry.getKey(), this.join((String[])entry.getValue()));
        }
        params.putAll(this.multipartParams);
        return Collections.unmodifiableMap(params);
    }

    @Override
    public String query(String name) {
        String[] param = this.request.getParameterValues(name);
        if (param != null) {
            return this.join(param);
        }
        String val = this.multipartParams.get(name);
        if (this.blade.enableXSS()) {
            return HTMLFilter.htmlSpecialChars((String)val);
        }
        return val;
    }

    @Override
    public Integer queryAsInt(String name) {
        String value = this.query(name);
        if (null != value) {
            return Integer.valueOf(value);
        }
        return null;
    }

    @Override
    public Long queryAsLong(String name) {
        String value = this.query(name);
        if (null != value) {
            return Long.valueOf(value);
        }
        return null;
    }

    @Override
    public Boolean queryAsBoolean(String name) {
        String value = this.query(name);
        if (null != value) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    @Override
    public Float queryAsFloat(String name) {
        String value = this.query(name);
        if (null != value) {
            return Float.valueOf(value);
        }
        return null;
    }

    @Override
    public Double queryAsDouble(String name) {
        String value = this.query(name);
        if (null != value) {
            return Double.valueOf(value);
        }
        return null;
    }

    @Override
    public String method() {
        return this.request.getMethod();
    }

    @Override
    public HttpMethod httpMethod() {
        return HttpMethod.valueOf(this.request.getMethod().toUpperCase());
    }

    @Override
    public String address() {
        return this.request.getRemoteAddr();
    }

    @Override
    public Session session() {
        if (this.session == null) {
            this.session = new Session(this.request.getSession());
        }
        return this.session;
    }

    @Override
    public Session session(boolean create) {
        HttpSession httpSession;
        if (this.session == null && (httpSession = this.request.getSession(create)) != null) {
            this.session = new Session(httpSession);
        }
        return this.session;
    }

    @Override
    public void attribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public <T> T attribute(String name) {
        Object object = this.request.getAttribute(name);
        if (null != object) {
            return (T)object;
        }
        return null;
    }

    @Override
    public Set<String> attributes() {
        HashSet<String> attrList = new HashSet<String>();
        Enumeration attributes = this.request.getAttributeNames();
        while (attributes.hasMoreElements()) {
            attrList.add((String)attributes.nextElement());
        }
        return attrList;
    }

    @Override
    public String contentType() {
        return this.request.getContentType();
    }

    @Override
    public int port() {
        return this.request.getServerPort();
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    @Override
    public boolean isAjax() {
        if (this.request.getHeader("x-requested-with") == null) {
            return false;
        }
        return "XMLHttpRequest".equals(this.request.getHeader("x-requested-with"));
    }

    @Override
    public Map<String, Cookie> cookies() {
        Cookie[] servletCookies = this.request.getCookies();
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        for (Cookie c : servletCookies) {
            cookies.put(c.getName(), this.map(c));
        }
        return Collections.unmodifiableMap(cookies);
    }

    private Cookie map(Cookie servletCookie) {
        String domain;
        Cookie cookie = new Cookie(servletCookie.getName(), servletCookie.getValue());
        cookie.setMaxAge(servletCookie.getMaxAge());
        cookie.setHttpOnly(servletCookie.isHttpOnly());
        String path = servletCookie.getPath();
        if (null != path) {
            cookie.setPath(path);
        }
        if (null != (domain = servletCookie.getDomain())) {
            cookie.setDomain(domain);
        }
        cookie.setSecure(servletCookie.getSecure());
        return cookie;
    }

    @Override
    public String cookie(String name) {
        Cookie cookie = this.cookieRaw(name);
        if (null != cookie) {
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public Cookie cookieRaw(String name) {
        Cookie[] servletCookies = this.request.getCookies();
        if (servletCookies == null) {
            return null;
        }
        for (Cookie c : servletCookies) {
            if (!c.getName().equals(name)) continue;
            return this.map(c);
        }
        return null;
    }

    @Override
    public Map<String, String> headers() {
        Enumeration servletHeaders = this.request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        while (servletHeaders.hasMoreElements()) {
            String headerName = (String)servletHeaders.nextElement();
            headers.put(headerName, this.request.getHeader(headerName));
        }
        return headers;
    }

    @Override
    public String header(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public void encoding(String encoding) {
        try {
            this.request.setCharacterEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public FileItem[] files() {
        FileItem[] fileParts = new FileItem[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            fileParts[i] = this.files.get(i);
        }
        return fileParts;
    }

    @Override
    public Request.BodyParser body() {
        return new Request.BodyParser(){

            @Override
            public String asString() throws HttpException {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)ServletRequest.this.request.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    String line = reader.readLine();
                    while (line != null) {
                        sb.append(line + "\n");
                        line = reader.readLine();
                    }
                    reader.close();
                    String data = sb.toString();
                    return data;
                }
                catch (IOException e) {
                    throw new HttpException(e);
                }
            }

            @Override
            public InputStream asInputStream() throws HttpException {
                try {
                    return ServletRequest.this.request.getInputStream();
                }
                catch (IOException e) {
                    throw new HttpException(e);
                }
            }

            @Override
            public byte[] asByte() {
                try {
                    return IOKit.toByteArray((InputStream)ServletRequest.this.request.getInputStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    @Override
    public void setRoute(Route route) {
        this.route = route;
        this.initPathParams(route.getPath());
    }
}

