/*
 * Decompiled with CFR 0.152.
 */
package com.blade.servlet;

import blade.kit.Assert;
import com.blade.Blade;
import com.blade.context.BladeWebContext;
import com.blade.http.HttpException;
import com.blade.http.Path;
import com.blade.http.Request;
import com.blade.http.Response;
import com.blade.render.ModelAndView;
import com.blade.render.Render;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class ServletResponse
implements Response {
    private HttpServletResponse response;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean written = false;
    private Render render;

    public ServletResponse(HttpServletResponse response, Render render) {
        this.response = response;
        this.render = render;
    }

    @Override
    public HttpServletResponse raw() {
        return this.response;
    }

    @Override
    public int status() {
        return this.response.getStatus();
    }

    @Override
    public Response status(int status) {
        this.response.setStatus(status);
        return this;
    }

    @Override
    public Response badRequest() {
        this.response.setStatus(400);
        return this;
    }

    @Override
    public Response unauthorized() {
        this.response.setStatus(401);
        return this;
    }

    @Override
    public Response notFound() {
        this.response.setStatus(404);
        return this;
    }

    @Override
    public Response conflict() {
        this.response.setStatus(409);
        return this;
    }

    @Override
    public String contentType() {
        return this.response.getContentType();
    }

    @Override
    public Response contentType(String contentType) {
        this.response.setContentType(contentType);
        return this;
    }

    @Override
    public String header(String name) {
        return this.response.getHeader(name);
    }

    @Override
    public Response header(String name, String value) {
        this.response.setHeader(name, value);
        return this;
    }

    @Override
    public Response cookie(Cookie cookie) {
        this.response.addCookie(cookie);
        return this;
    }

    @Override
    public Response cookie(String name, String value) {
        return this.cookie(name, value);
    }

    @Override
    public Response cookie(String name, String value, int maxAge) {
        return this.cookie(name, value, maxAge);
    }

    @Override
    public Response cookie(String name, String value, int maxAge, boolean secured) {
        return this.cookie(name, value, maxAge, secured);
    }

    @Override
    public Response cookie(String path, String name, String value, int maxAge, boolean secured) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secured);
        this.response.addCookie(cookie);
        return this;
    }

    @Override
    public Response removeCookie(Cookie cookie) {
        cookie.setMaxAge(0);
        this.response.addCookie(this.map(cookie));
        return this;
    }

    Cookie map(Cookie cookie) {
        Cookie servletCookie = new Cookie(cookie.getName(), cookie.getValue());
        servletCookie.setMaxAge(cookie.getMaxAge());
        if (cookie.getPath() != null) {
            servletCookie.setPath(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            servletCookie.setDomain(cookie.getDomain());
        }
        servletCookie.setHttpOnly(cookie.isHttpOnly());
        servletCookie.setSecure(cookie.getSecure());
        return servletCookie;
    }

    @Override
    public Response removeCookie(String name) {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
        return this;
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attributes;
    }

    @Override
    public Response attribute(String name, Object object) {
        this.attributes.put(name, object);
        return this;
    }

    @Override
    public Response text(String text) {
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setContentType("text/plain;charset=utf-8");
            this.response.getWriter().print(text);
            this.written = true;
            return this;
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public Response html(String html) {
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setContentType("text/html;charset=utf-8");
            PrintWriter out = this.response.getWriter();
            out.print(html);
            out.flush();
            out.close();
            this.written = true;
            return this;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Response json(String json) {
        Request request = BladeWebContext.request();
        String userAgent = request.userAgent();
        if (userAgent.contains("MSIE")) {
            this.response.setContentType("text/html;charset=utf-8");
        } else {
            this.response.setContentType("application/json;charset=utf-8");
        }
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = this.response.getWriter();
            out.print(json);
            out.flush();
            out.close();
            this.written = true;
            return this;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Response xml(String xml) {
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setContentType("text/xml;charset=utf-8");
            PrintWriter out = this.response.getWriter();
            out.print(xml);
            out.flush();
            out.close();
            this.written = true;
            return this;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ServletOutputStream outputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public Response render(String view) {
        try {
            Assert.notBlank((CharSequence)view, (String)"view not is null", (Object[])new Object[0]);
            Blade blade = Blade.me();
            String viewPath = blade.viewPrefix() + view + blade.viewSuffix();
            if (view.endsWith(blade.viewSuffix())) {
                viewPath = blade.viewPrefix() + view;
            }
            viewPath = Path.cleanPath(viewPath);
            ModelAndView modelAndView = new ModelAndView(viewPath);
            this.render.render(modelAndView, this.response.getWriter());
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Response render(ModelAndView modelAndView) {
        try {
            Assert.notNull((Object)modelAndView, (String)"ModelAndView not is null!");
            Assert.notBlank((CharSequence)modelAndView.getView(), (String)"view not is null", (Object[])new Object[0]);
            Blade blade = Blade.me();
            String viewPath = blade.viewPrefix() + modelAndView.getView() + blade.viewSuffix();
            if (modelAndView.getView().endsWith(blade.viewSuffix())) {
                viewPath = blade.viewPrefix() + modelAndView.getView();
            }
            viewPath = Path.cleanPath(viewPath);
            modelAndView.setView(viewPath);
            this.render.render(modelAndView, this.response.getWriter());
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void redirect(String path) {
        try {
            this.response.sendRedirect(path);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public void go(String path) {
        try {
            String ctx = BladeWebContext.servletContext().getContextPath();
            String location = Path.fixPath(ctx + path);
            this.response.sendRedirect(location);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public boolean isWritten() {
        return this.written;
    }
}

