/*
 * Decompiled with CFR 0.152.
 */
package com.blade.servlet.multipart;

import blade.kit.IOKit;
import com.blade.servlet.multipart.FileItem;
import com.blade.servlet.multipart.MultipartException;
import com.blade.servlet.multipart.MultipartHandler;
import com.blade.servlet.multipart.MultipartReader;
import com.blade.servlet.multipart.ParameterParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class Multipart {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    public static boolean isMultipartContent(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public void parse(HttpServletRequest request, MultipartHandler partHandler) throws IOException, MultipartException {
        if (!Multipart.isMultipartContent(request)) {
            throw new MultipartException("Not a multipart content. The HTTP method should be 'POST' and the Content-Type 'multipart/form-data' or 'multipart/mixed'.");
        }
        ServletInputStream inputStream = request.getInputStream();
        String contentType = request.getContentType();
        String charEncoding = request.getCharacterEncoding();
        byte[] boundary = this.getBoundary(contentType);
        if (boundary == null) {
            throw new MultipartException("the request was rejected because no multipart boundary was found");
        }
        MultipartReader multipartReader = new MultipartReader((InputStream)inputStream, boundary);
        multipartReader.setHeaderEncoding(charEncoding);
        String currentFieldName = null;
        boolean skipPreamble = true;
        while (true) {
            String partContentType;
            boolean nextPart;
            if (!(nextPart = skipPreamble ? multipartReader.skipPreamble() : multipartReader.readBoundary())) {
                if (currentFieldName == null) {
                    return;
                }
                multipartReader.setBoundary(boundary);
                currentFieldName = null;
                continue;
            }
            String headersString = multipartReader.readHeaders();
            Map<String, String> headers = this.getHeadersMap(headersString);
            if (currentFieldName == null) {
                String fieldName = this.getFieldName(headers.get(CONTENT_DISPOSITION));
                if (fieldName != null) {
                    partContentType = headers.get(CONTENT_TYPE);
                    if (partContentType != null && partContentType.toLowerCase().startsWith(MULTIPART_MIXED)) {
                        currentFieldName = fieldName;
                        multipartReader.setBoundary(this.getBoundary(partContentType));
                        skipPreamble = true;
                        continue;
                    }
                    String fileName = this.getFileName(headers.get(CONTENT_DISPOSITION));
                    if (fileName == null) {
                        String value = IOKit.toString((InputStream)multipartReader.newInputStream());
                        partHandler.handleFormItem(fieldName, value);
                        continue;
                    }
                    File tempFile = this.createTempFile(multipartReader);
                    FileItem fileItem = new FileItem(fieldName, fileName, partContentType, tempFile.length(), tempFile, headers);
                    partHandler.handleFileItem(fieldName, fileItem);
                    continue;
                }
            } else {
                String fileName = this.getFileName(headers.get(CONTENT_DISPOSITION));
                partContentType = headers.get(CONTENT_TYPE);
                if (fileName != null) {
                    File tempFile = this.createTempFile(multipartReader);
                    FileItem fileItem = new FileItem(currentFieldName, fileName, partContentType, tempFile.length(), tempFile, headers);
                    partHandler.handleFileItem(currentFieldName, fileItem);
                    continue;
                }
            }
            multipartReader.discardBodyData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(MultipartReader multipartReader) throws IOException {
        File tempFile = File.createTempFile("com.blade.file_", null);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempFile);
            this.copy(multipartReader.newInputStream(), outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return tempFile;
    }

    private long copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    protected Map<String, String> getHeadersMap(String headerPart) {
        int end;
        int len = headerPart.length();
        HashMap<String, String> headers = new HashMap<String, String>();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            int colonOffset;
            String header = headerPart.substring(start, end);
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header = header + " " + headerPart.substring(nonWs, end);
                start = end + 2;
            }
            if ((colonOffset = header.indexOf(58)) == -1) continue;
            String headerName = header.substring(0, colonOffset).trim();
            String headerValue = header.substring(header.indexOf(58) + 1).trim();
            if (headers.containsKey(headerName)) {
                headers.put(headerName, (String)headers.get(headerName) + "," + headerValue);
                continue;
            }
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private String getFieldName(String contentDisposition) {
        String fieldName = null;
        if (contentDisposition != null && contentDisposition.toLowerCase().startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentDisposition, ';');
            fieldName = params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    protected byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    private String getFileName(String contentDisposition) {
        String cdl;
        String fileName = null;
        if (contentDisposition != null && ((cdl = contentDisposition.toLowerCase()).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentDisposition, ';');
            if (params.containsKey("filename")) {
                fileName = params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }
}

