/*
 * Decompiled with CFR 0.152.
 */
package com.blade.servlet.multipart;

import com.blade.servlet.multipart.Streams;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MultipartReader {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    public static final int HEADER_PART_SIZE_MAX = 10240;
    protected static final int DEFAULT_BUFSIZE = 4096;
    protected static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    protected static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    protected static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    protected static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private final InputStream input;
    private int boundaryLength;
    private int keepRegion;
    private byte[] boundary;
    private final int bufSize;
    private final byte[] buffer;
    private int head;
    private int tail;
    private String headerEncoding;

    public MultipartReader(InputStream input, byte[] boundary, int bufSize) {
        this.input = input;
        this.bufSize = bufSize;
        this.buffer = new byte[bufSize];
        this.boundary = new byte[boundary.length + BOUNDARY_PREFIX.length];
        this.boundaryLength = boundary.length + BOUNDARY_PREFIX.length;
        this.keepRegion = this.boundary.length;
        System.arraycopy(BOUNDARY_PREFIX, 0, this.boundary, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(boundary, 0, this.boundary, BOUNDARY_PREFIX.length, boundary.length);
        this.head = 0;
        this.tail = 0;
    }

    public MultipartReader(InputStream input, byte[] boundary) {
        this(input, boundary, 4096);
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    public byte readByte() throws IOException {
        if (this.head == this.tail) {
            this.head = 0;
            this.tail = this.input.read(this.buffer, this.head, this.bufSize);
            if (this.tail == -1) {
                throw new IOException("No more data is available");
            }
        }
        return this.buffer[this.head++];
    }

    public boolean readBoundary() throws MalformedStreamException {
        boolean nextChunk;
        block4: {
            byte[] marker = new byte[2];
            nextChunk = false;
            this.head += this.boundaryLength;
            try {
                marker[0] = this.readByte();
                marker[1] = this.readByte();
                if (MultipartReader.arrayequals(marker, STREAM_TERMINATOR, 2)) {
                    nextChunk = false;
                    break block4;
                }
                if (MultipartReader.arrayequals(marker, FIELD_SEPARATOR, 2)) {
                    nextChunk = true;
                    break block4;
                }
                throw new MalformedStreamException("Unexpected characters follow a boundary");
            }
            catch (IOException e) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
        }
        return nextChunk;
    }

    public void setBoundary(byte[] boundary) throws IllegalBoundaryException {
        if (boundary.length != this.boundaryLength - BOUNDARY_PREFIX.length) {
            throw new IllegalBoundaryException("The length of a boundary token can not be changed");
        }
        System.arraycopy(boundary, 0, this.boundary, BOUNDARY_PREFIX.length, boundary.length);
    }

    public String readHeaders() throws MalformedStreamException {
        int i = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int size = 0;
        while (i < HEADER_SEPARATOR.length) {
            byte b;
            try {
                b = this.readByte();
            }
            catch (IOException e) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
            if (++size > 10240) {
                throw new MalformedStreamException("Header section has more than 10240 bytes (maybe it is not properly terminated)");
            }
            i = b == HEADER_SEPARATOR[i] ? ++i : 0;
            baos.write(b);
        }
        String headers = null;
        if (this.headerEncoding != null) {
            try {
                headers = baos.toString(this.headerEncoding);
            }
            catch (UnsupportedEncodingException e) {
                headers = baos.toString();
            }
        } else {
            headers = baos.toString();
        }
        return headers;
    }

    public int readBodyData(OutputStream output) throws MalformedStreamException, IOException {
        ItemInputStream istream = this.newInputStream();
        return (int)Streams.copy(istream, output, false);
    }

    protected ItemInputStream newInputStream() {
        return new ItemInputStream();
    }

    public int discardBodyData() throws MalformedStreamException, IOException {
        return this.readBodyData(null);
    }

    public boolean skipPreamble() throws IOException {
        System.arraycopy(this.boundary, 2, this.boundary, 0, this.boundary.length - 2);
        this.boundaryLength = this.boundary.length - 2;
        try {
            this.discardBodyData();
            boolean bl = this.readBoundary();
            return bl;
        }
        catch (MalformedStreamException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            System.arraycopy(this.boundary, 0, this.boundary, 2, this.boundary.length - 2);
            this.boundaryLength = this.boundary.length;
            this.boundary[0] = 13;
            this.boundary[1] = 10;
        }
    }

    public static boolean arrayequals(byte[] a, byte[] b, int count) {
        for (int i = 0; i < count; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected int findByte(byte value, int pos) {
        for (int i = pos; i < this.tail; ++i) {
            if (this.buffer[i] != value) continue;
            return i;
        }
        return -1;
    }

    protected int findSeparator() {
        int first;
        int match = 0;
        int maxpos = this.tail - this.boundaryLength;
        for (first = this.head; first <= maxpos && match != this.boundaryLength; ++first) {
            if ((first = this.findByte(this.boundary[0], first)) == -1 || first > maxpos) {
                return -1;
            }
            for (match = 1; match < this.boundaryLength && this.buffer[first + match] == this.boundary[match]; ++match) {
            }
        }
        if (match == this.boundaryLength) {
            return first - 1;
        }
        return -1;
    }

    public class ItemInputStream
    extends InputStream
    implements Closeable {
        private long total;
        private int pad;
        private int pos;
        private boolean closed;
        private static final int BYTE_POSITIVE_OFFSET = 256;

        ItemInputStream() {
            this.findSeparator();
        }

        private void findSeparator() {
            this.pos = MultipartReader.this.findSeparator();
            if (this.pos == -1) {
                this.pad = MultipartReader.this.tail - MultipartReader.this.head > MultipartReader.this.keepRegion ? MultipartReader.this.keepRegion : MultipartReader.this.tail - MultipartReader.this.head;
            }
        }

        public long getBytesRead() {
            return this.total;
        }

        @Override
        public int available() throws IOException {
            if (this.pos == -1) {
                return MultipartReader.this.tail - MultipartReader.this.head - this.pad;
            }
            return this.pos - MultipartReader.this.head;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("The stream is closed.");
            }
            if (this.available() == 0 && this.makeAvailable() == 0) {
                return -1;
            }
            ++this.total;
            byte b = MultipartReader.this.buffer[MultipartReader.this.head++];
            if (b >= 0) {
                return b;
            }
            return b + 256;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("The stream is closed.");
            }
            if (len == 0) {
                return 0;
            }
            int res = this.available();
            if (res == 0 && (res = this.makeAvailable()) == 0) {
                return -1;
            }
            res = Math.min(res, len);
            System.arraycopy(MultipartReader.this.buffer, MultipartReader.this.head, b, off, res);
            MultipartReader.this.head = MultipartReader.this.head + res;
            this.total += (long)res;
            return res;
        }

        @Override
        public void close() throws IOException {
            this.close(false);
        }

        public void close(boolean pCloseUnderlying) throws IOException {
            if (this.closed) {
                return;
            }
            if (pCloseUnderlying) {
                this.closed = true;
                MultipartReader.this.input.close();
            } else {
                int av;
                while ((av = this.available()) != 0 || (av = this.makeAvailable()) != 0) {
                    this.skip(av);
                }
            }
            this.closed = true;
        }

        @Override
        public long skip(long bytes) throws IOException {
            if (this.closed) {
                throw new IOException("The stream is closed.");
            }
            int av = this.available();
            if (av == 0 && (av = this.makeAvailable()) == 0) {
                return 0L;
            }
            long res = Math.min((long)av, bytes);
            MultipartReader.this.head = (int)((long)MultipartReader.this.head + res);
            return res;
        }

        private int makeAvailable() throws IOException {
            int av;
            if (this.pos != -1) {
                return 0;
            }
            this.total += (long)(MultipartReader.this.tail - MultipartReader.this.head - this.pad);
            System.arraycopy(MultipartReader.this.buffer, MultipartReader.this.tail - this.pad, MultipartReader.this.buffer, 0, this.pad);
            MultipartReader.this.head = 0;
            MultipartReader.this.tail = this.pad;
            do {
                int bytesRead;
                if ((bytesRead = MultipartReader.this.input.read(MultipartReader.this.buffer, MultipartReader.this.tail, MultipartReader.this.bufSize - MultipartReader.this.tail)) == -1) {
                    String msg = "Stream ended unexpectedly";
                    throw new MalformedStreamException("Stream ended unexpectedly");
                }
                MultipartReader.this.tail = MultipartReader.this.tail + bytesRead;
                this.findSeparator();
            } while ((av = this.available()) <= 0 && this.pos == -1);
            return av;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    public static class IllegalBoundaryException
    extends IOException {
        public IllegalBoundaryException() {
        }

        public IllegalBoundaryException(String message) {
            super(message);
        }
    }

    public static class MalformedStreamException
    extends IOException {
        public MalformedStreamException() {
        }

        public MalformedStreamException(String message) {
            super(message);
        }
    }
}

