/*
 * Decompiled with CFR 0.152.
 */
package com.blade.verify;

import blade.kit.HashidKit;
import blade.kit.StringKit;
import blade.kit.log.Logger;
import com.blade.http.Request;
import com.blade.http.Response;
import com.blade.servlet.Session;
import com.blade.verify.CSRFConfig;

public class CSRFTokenManager {
    private static Logger LOGGER = Logger.getLogger(CSRFTokenManager.class);
    private static CSRFConfig config = new CSRFConfig();
    private static HashidKit HASHID = new HashidKit(CSRFTokenManager.config.secret, CSRFTokenManager.config.length);

    private CSRFTokenManager() {
    }

    public static void config(CSRFConfig config) {
        CSRFTokenManager.config = config;
        HASHID = new HashidKit(config.secret, config.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createToken(Request request, Response response) {
        String token = null;
        Request request2 = request;
        synchronized (request2) {
            Session session = request.session();
            String objToken = (String)session.attribute(CSRFTokenManager.config.session);
            token = null == objToken ? HASHID.encode(new long[]{System.currentTimeMillis()}) : objToken.toString();
            session.attribute(CSRFTokenManager.config.session, token);
            if (CSRFTokenManager.config.setHeader) {
                response.header(CSRFTokenManager.config.header, token);
            }
            if (CSRFTokenManager.config.setCookie) {
                response.cookie(CSRFTokenManager.config.cookiePath, CSRFTokenManager.config.cookie, token, CSRFTokenManager.config.expire, CSRFTokenManager.config.secured);
            }
            LOGGER.info((Object)("create csrf_token\uff1a" + token));
        }
        return token;
    }

    public static boolean verifyAsForm(Request request, Response response) {
        String sToken = (String)request.session().attribute(CSRFTokenManager.config.session);
        if (sToken == null) {
            sToken = CSRFTokenManager.createToken(request, response);
            return true;
        }
        String pToken = request.query(CSRFTokenManager.config.form);
        return StringKit.isNotBlank((String)pToken) && sToken.equals(pToken);
    }

    public static boolean verifyAsHeader(Request request, Response response) {
        String sToken = (String)request.session().attribute(CSRFTokenManager.config.session);
        if (sToken == null) {
            sToken = CSRFTokenManager.createToken(request, response);
            return true;
        }
        String pToken = request.header(CSRFTokenManager.config.header);
        return StringKit.isNotBlank((String)pToken) && sToken.equals(pToken);
    }

    public static boolean verifyAsCookie(Request request, Response response) {
        String sToken = (String)request.session().attribute(CSRFTokenManager.config.session);
        if (sToken == null) {
            sToken = CSRFTokenManager.createToken(request, response);
            return true;
        }
        String pToken = request.cookie(CSRFTokenManager.config.cookie);
        return StringKit.isNotBlank((String)pToken) && sToken.equals(pToken);
    }
}

